package com.biz.crm.business.common.page.cache.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 分页缓存服务
 * @author wanghaojia
 * @date 2022/12/7 11:39
 */
public interface BusinessPageCacheService<Vo,Dto> {

    /**
     * 1、获取明细列表分页接口
     * @param pageable 分页参数
     * @param cacheKey 缓存key
     */
    Page<Vo> findCachePageList(Pageable pageable,Dto dto, String cacheKey);

    /**
     * 获取缓存中的所有明细行
     * @param cacheKey 缓存key
     */
    List<Dto> findCacheList(String cacheKey);

    /**
     * 2、新增一行接口，在缓存中行首插入一条数据
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void addItemCache(String cacheKey, List<Dto> itemList);

    /**
     * 3、复制行接口，保存当前页数据后，在缓存中行首复制选中数据并返回第一页数据
     * @param cacheKey 缓存key
     * @param itemList 要保存的当前页数据
     */
    void copyItemListCache(String cacheKey, List<Dto> itemList);

    /**
     * 4、保存当前页数据到缓存并返回指定页数据接口
     * @param cacheKey 缓存key
     */
    void saveCurrentPageCache(String cacheKey, List<Dto> saveList);

    /**
     * 保存缓存集合
     * @param cacheKey
     * @param saveList
     */
    void saveListCache(String cacheKey,List<Dto> saveList);

    /**
     * 7、多行删除并保存当前页数据并返回指定页数据接口
     * @param cacheKey 缓存key
     */
    void deleteCacheList(String cacheKey, List<Dto> itemList);

    /**
     * 6、清理缓存接口
     * @param cacheKey 缓存key
     */
    void clearCache(String cacheKey);


}
