package com.biz.crm.business.common.page.cache.constant;

/**
 * 缓存分页常量
 *
 * @author wanghaojia
 * @date 2022/12/7 13:33
 */
public interface BusinessPageCacheConstant {

    /**
     * id键
     */
    String REDIS_KEY_ID = "id:";

    /**
     * data数据键
     */
    String REDIS_KEY_DATA = "data:";

    /**
     * 是否初始化数据键
     */
    String REDIS_KEY_INIT = "init:";

    /**
     * 缓存分页锁键
     */
    String REDIS_PAGE_KEY_LOCK = "lock:";

    /**
     * 分页缓存过期时间，默认1小时
     */
    long DEFAULT_PAGE_CACHE_EXPIRE_TIME = 60 * 60;


    String ES_INDEX_NAME_BUSINESS_IMPORT_CACHE = "business_import_cache";

    String BUSINESS_IMPORT_CACHE_DEL = "business_import_cache:lock:del";

}
