/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.page.cache.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.page.cache.service.BusinessPageCacheHelper;
import com.biz.crm.business.common.page.cache.service.BusinessPageCacheService;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class BusinessPageCacheServiceImpl<Vo, Dto>
implements BusinessPageCacheService<Vo, Dto> {
    @Autowired(required=false)
    protected BusinessPageCacheHelper<Vo, Dto> helper;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public Page<Vo> findCachePageList(Pageable pageable, Dto dto, String cacheKey) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheIdKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheIdKey);
            page.setTotal(total.longValue());
            List idList = this.redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)idList)) {
                List dataList;
                List dtoList = dataList = this.redisTemplate.opsForHash().multiGet((Object)redisCacheDataKey, (Collection)idList);
                List<Vo> voList = this.helper.dtoListToVoList(dtoList);
                page.setRecords(voList);
            }
        } else if (!this.redisService.hasKey(redisCacheInitKey).booleanValue() && null != dto) {
            this.redisService.set(redisCacheInitKey, (Object)BooleanEnum.TRUE, this.helper.getExpireTime());
            try {
                List<Dto> dtoList = this.helper.findDtoListFromRepository(dto, cacheKey);
                if (CollectionUtils.isEmpty(dtoList)) {
                    this.redisService.del(redisCacheInitKey);
                } else {
                    if (this.helper.initToCacheFromRepository()) {
                        this.helper.putCache(cacheKey, dtoList);
                    }
                    page.setTotal((long)dtoList.size());
                    long start = page.offset();
                    if (page.getTotal() > start) {
                        long end = page.offset() + page.getSize();
                        if (page.getTotal() < end) {
                            end = page.getTotal();
                        }
                        List<Dto> recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                        List<Vo> voList = this.helper.dtoListToVoList(recordDtoList);
                        page.setRecords(voList);
                    }
                }
            }
            catch (Exception e) {
                this.redisService.del(redisCacheInitKey);
            }
        }
        this.helper.fillVoListProperties(page.getRecords());
        return page;
    }

    @Override
    public List<Dto> findCacheList(String cacheKey) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        ArrayList dataList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            for (String idKey : idKeys) {
                String dataKey = idKey.replace("id:", "data:");
                List idList = this.redisService.lRange(idKey, 0L, -1L);
                dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, (Collection)idList));
            }
        }
        return dataList;
    }

    @Override
    public void addItemCache(String cacheKey, List<Dto> itemList) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List updateList = itemList.stream().filter(item -> idList.contains(this.helper.getDtoKey(item))).collect(Collectors.toList());
        this.helper.updateItem(cacheKey, updateList);
        this.helper.filterSaveItem(cacheKey, idList, itemList, updateList);
        List<Dto> newItemList = this.helper.newItem(cacheKey, itemList);
        Object[] newIdArr = newItemList.stream().map(this.helper::getDtoKey).toArray();
        this.helper.doSaveNewKey(cacheKey, newIdArr);
        if (!CollectionUtils.isEmpty(newItemList)) {
            updateList.addAll(newItemList);
        }
        Map updateMap = updateList.stream().collect(Collectors.toMap(this.helper::getDtoKey, Function.identity()));
        this.helper.doSaveItem(cacheKey, updateMap);
    }

    @Override
    public void copyItemListCache(String cacheKey, List<Dto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List updateList = itemList.stream().filter(item -> idList.contains(this.helper.getDtoKey(item))).collect(Collectors.toList());
        this.helper.updateItem(cacheKey, updateList);
        List copyList = itemList.stream().filter(item -> BooleanEnum.TRUE.getNumStr().equals(this.helper.getCheckedStatus(item))).collect(Collectors.toList());
        List<Dto> newItemList = this.helper.copyItem(cacheKey, copyList);
        Object[] newIdArr = newItemList.stream().map(this.helper::getDtoKey).toArray();
        this.helper.doSaveNewKey(cacheKey, newIdArr);
        updateList.addAll(newItemList);
        Map updateMap = updateList.stream().collect(Collectors.toMap(this.helper::getDtoKey, Function.identity()));
        this.helper.doSaveItem(cacheKey, updateMap);
    }

    @Override
    public void saveCurrentPageCache(String cacheKey, List<Dto> saveList) {
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        this.helper.updateItem(cacheKey, saveList);
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Map updateMap = saveList.stream().collect(Collectors.toMap(this.helper::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.helper.getExpireTime());
    }

    @Override
    public void saveListCache(String cacheKey, List<Dto> itemList) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List updateList = itemList.stream().filter(item -> idList.contains(this.helper.getDtoKey(item))).collect(Collectors.toList());
        this.helper.updateItem(cacheKey, updateList);
        this.helper.filterSaveItem(cacheKey, idList, itemList, updateList);
        Object[] newIdArr = itemList.stream().map(this.helper::getDtoKey).toArray();
        this.helper.doSaveNewKey(cacheKey, newIdArr);
        updateList.addAll(itemList);
        Map updateMap = updateList.stream().collect(Collectors.toMap(this.helper::getDtoKey, Function.identity()));
        this.helper.doSaveItem(cacheKey, updateMap);
    }

    @Override
    public void deleteCacheList(String cacheKey, List<Dto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        ArrayList deleteIdList = Lists.newArrayList();
        HashMap updateMap = Maps.newHashMap();
        ArrayList updateList = Lists.newArrayList();
        for (Dto dto : itemList) {
            if (BooleanEnum.TRUE.getNumStr().equals(this.helper.getCheckedStatus(dto))) {
                deleteIdList.add(this.helper.getDtoKey(dto));
                continue;
            }
            updateMap.put(this.helper.getDtoKey(dto), dto);
            updateList.add(dto);
        }
        if (updateMap.size() > 0) {
            this.helper.updateItem(cacheKey, updateList);
            this.helper.doSaveItem(cacheKey, updateMap);
        }
        if (!CollectionUtils.isEmpty((Collection)deleteIdList)) {
            for (Object id : deleteIdList) {
                this.redisService.lRemove(redisCacheIdKey, 0L, id);
            }
            this.redisTemplate.opsForHash().delete((Object)redisCacheDataKey, deleteIdList.toArray());
        }
    }

    @Override
    public void clearCache(String cacheKey) {
        Set initKeys;
        Set dataKeys;
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        HashSet delKeys = Sets.newHashSet();
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            delKeys.addAll(idKeys);
        }
        if (!CollectionUtils.isEmpty((Collection)(dataKeys = this.redisTemplate.keys((Object)(redisCacheDataKey + "*"))))) {
            delKeys.addAll(dataKeys);
        }
        if (!CollectionUtils.isEmpty((Collection)(initKeys = this.redisTemplate.keys((Object)(redisCacheInitKey + "*"))))) {
            delKeys.addAll(initKeys);
        }
        if (!CollectionUtils.isEmpty((Collection)delKeys)) {
            this.redisTemplate.delete((Collection)delKeys);
        }
    }
}

