package com.biz.crm.business.common.page.cache.repository;

import com.biz.crm.business.common.page.cache.constant.BusinessPageCacheConstant;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.io.Serializable;

/**
 * @describe 导入缓存
 * @author wanghaojia
 * @date 2023/12/21 22:01
 */
@Getter
@Setter
@Document(indexName = BusinessPageCacheConstant.ES_INDEX_NAME_BUSINESS_IMPORT_CACHE)
public class BusinessImportCacheEsDocument implements Serializable {

    private static final long serialVersionUID = -7054530874530734822L;
    
    @Id
    private String id;

    @ApiModelProperty("网关内部的某个顶级租户编号")
    @Field(type = FieldType.Keyword)
    private String tenantCode;

    @ApiModelProperty("业务功能")
    @Field(type = FieldType.Keyword)
    private String businessKey;

    @ApiModelProperty("缓存键")
    @Field(type = FieldType.Keyword)
    private String cacheKey;

    @ApiModelProperty("请求时间")
    @Field(type = FieldType.Keyword)
    private String reqDate;

    @ApiModelProperty("数据集合")
    @Field(type = FieldType.Text)
    private String dataListJson;

}