package com.biz.crm.business.common.page.cache.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.page.cache.service.BusinessImportCacheService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 导入缓存处理
 * @author wanghaojia
 * @date 2023/12/21 22:01
 */
@Slf4j
@RestController
@RequestMapping(value = "/v1/import/business/cache")
public class BusinessImportCacheController {

    @Autowired(required = false)
    private BusinessImportCacheService importCacheService;

    @GetMapping(value = "getDataListJson")
    public Result getDataListJson(@RequestParam(value = "businessKey",required = false) String businessKey,@RequestParam(value = "cacheKey") String cacheKey){
        try {
            String dataListJson = importCacheService.getDataListJson(businessKey,cacheKey);
            return Result.ok(JSONObject.parseArray(dataListJson));
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error("导入数据获取失败："+e.getMessage());
        }
    }

}
