/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.page.cache.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public abstract class BusinessPageCacheHelper<Vo, Dto> {
    @Autowired(required=false)
    protected RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public abstract String getCacheKeyPrefix();

    public abstract Class<Dto> getDtoClass();

    public abstract Class<Vo> getVoClass();

    public abstract List<Dto> findDtoListFromRepository(Dto var1, String var2);

    public boolean initToCacheFromRepository() {
        return true;
    }

    public void putCache(String cacheKey, List<Dto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), list.stream().map(this::getDtoKey).toArray());
        Map newDataMap = list.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity(), (o, n) -> n));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, newDataMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public abstract List<Dto> newItem(String var1, List<Dto> var2);

    public void doSaveNewKey(String cacheKey, Object[] newIdArr) {
        if (newIdArr.length == 0) {
            return;
        }
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        this.redisTemplate.opsForList().leftPushAll((Object)redisCacheIdKey, newIdArr);
        this.redisService.expire(redisCacheIdKey, this.getExpireTime());
    }

    public abstract List<Dto> copyItem(String var1, List<Dto> var2);

    public void updateItem(String cacheKey, List<Dto> itemList) {
    }

    public void doSaveItem(String cacheKey, Map<Object, Dto> updateMap) {
        if (null == updateMap || updateMap.size() == 0) {
            return;
        }
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public abstract Object getDtoKey(Dto var1);

    public abstract String getCheckedStatus(Dto var1);

    public String getRedisCacheIdKey(String cacheKey) {
        return this.getCacheKeyPrefix() + "id:" + cacheKey;
    }

    public String getRedisCacheDataKey(String cacheKey) {
        return this.getCacheKeyPrefix() + "data:" + cacheKey;
    }

    public String getRedisCacheInitKey(String cacheKey) {
        return this.getCacheKeyPrefix() + "init:" + cacheKey;
    }

    public String getRedisPageCacheLockKey(String cacheKey) {
        return this.getCacheKeyPrefix() + "lock:" + cacheKey;
    }

    public long getExpireTime() {
        return 3600L;
    }

    public void fillVoListProperties(List<Vo> records) {
    }

    public List<Vo> dtoListToVoList(List<Dto> dtoList) {
        return JSONObject.parseArray((String)JSONObject.toJSONString(dtoList), this.getVoClass());
    }

    public Integer getTotal(String cacheKey) {
        return this.redisService.lSize(this.getRedisCacheIdKey(cacheKey)).intValue();
    }

    public Dto getDtoByKey(String cacheKey, String dtoKey) {
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        Object object = this.redisTemplate.opsForHash().get((Object)redisCacheDataKey, (Object)dtoKey);
        if (null == object) {
            return null;
        }
        return (Dto)object;
    }

    public void filterSaveItem(String cacheKey, List<Object> idList, List<Dto> itemList, List<Dto> updateList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.removeIf(item -> idList.contains(this.getDtoKey(item)));
    }
}

