/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.ie.local;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.base.constant.BusinessConstant;
import com.biz.crm.business.common.ie.local.BusinessCrmImportExcelReadListener;
import com.biz.crm.business.common.ie.sdk.process.BusinessExportProcess;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.bean.ExportSendProcessMsgBean;
import com.biz.crm.common.ie.local.bean.ImportSendProcessMsgBean;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.listener.EasyExcelListener;
import com.biz.crm.common.ie.local.model.vo.ImportExcelReadModelVo;
import com.biz.crm.common.ie.local.repository.ExportTaskRepository;
import com.biz.crm.common.ie.local.service.strategy.CrmExportExcelReadListener;
import com.biz.crm.common.ie.sdk.enums.ExcelFileTypeEnum;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.util.BzExcelUtil;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.strategy.ImportExcelStrategy;
import com.biz.crm.common.ie.sdk.vo.ExcelFileVo;
import com.biz.crm.common.ie.sdk.vo.ExportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskDetailVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BusinessCrmExcelImportExportProcessStrategy {
    private static final Logger log = LoggerFactory.getLogger(BusinessCrmExcelImportExportProcessStrategy.class);
    @Autowired
    private ImportSendProcessMsgBean importMsgBean;
    @Autowired
    private ExportSendProcessMsgBean exportSendProcessMsgBean;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private ExportTaskRepository exportTaskRepository;
    @Autowired(required=false)
    private List<ImportExcelStrategy> importExcelStrategies;
    @Value(value="${import.type:#{'default'}}")
    private String importType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportTaskHandlerResultVo importExcel(ImportProcess<CrmExcelVo> process, TaskGlobalParamsVo paramsVo, Map<String, Object> params, Map<String, ExcelFileVo> fileMap) {
        Validate.isTrue((Objects.nonNull(paramsVo) && StringUtils.isNotBlank((CharSequence)paramsVo.getTaskCode()) ? 1 : 0) != 0, (String)"\u4efb\u52a1\u516c\u53c2\u7f16\u7801\u4e3a\u5fc5\u8981\u53c2\u6570", (Object[])new Object[0]);
        ImportTaskHandlerResultVo resultVo = new ImportTaskHandlerResultVo();
        ExcelFileVo originalFile = fileMap.get(ExcelFileTypeEnum.ORIGINAL.getDictCode());
        ExcelFileVo errorFileVo = fileMap.get(ExcelFileTypeEnum.ERROR.getDictCode());
        File errorFile = new File(errorFileVo.getPath());
        CrmExcelImport crmExcelImport = process.findCrmExcelVoClass().getAnnotation(CrmExcelImport.class);
        ImportExcelReadModelVo readVo = new ImportExcelReadModelVo();
        readVo.setMsgBean(this.importMsgBean);
        readVo.setProcess(process);
        readVo.setParamsVo(paramsVo);
        readVo.setParams(params);
        ExcelWriter excelWriter = null;
        int failedNum = 0;
        try {
            Integer totalRow = this.findExcelTotalRowIgnoreBlankLines(originalFile.getPath(), crmExcelImport.sheetNo());
            Validate.isTrue((totalRow.compareTo(crmExcelImport.startRow()) >= 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165excel\u603b\u8bb0\u5f55\u6570\u987b\u5927\u4e8e\u5f00\u59cb\u5904\u7406\u884c\u6570", (Object[])new Object[0]);
            resultVo.setTotal(totalRow - crmExcelImport.startRow());
            excelWriter = ((ExcelWriterBuilder)EasyExcelFactory.write((File)errorFile).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
            readVo.setTotal(resultVo.getTotal());
            List importExcelStrategyList = this.importExcelStrategies.stream().filter(importExcelStrategy -> importExcelStrategy.importExcelType().equals(this.importType)).collect(Collectors.toList());
            Validate.isTrue((!CollectionUtils.isEmpty(importExcelStrategyList) ? 1 : 0) != 0, (String)"\u5bfc\u5165\u5339\u914d\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5yml\u914d\u7f6e\u4fe1\u606fimport.type\u662f\u5426\u914d\u7f6e", (Object[])new Object[0]);
            ImportExcelStrategy importExcelStrategy2 = (ImportExcelStrategy)importExcelStrategyList.get(0);
            ((ExcelReaderSheetBuilder)EasyExcelFactory.read((String)originalFile.getPath(), (ReadListener)new BusinessCrmImportExcelReadListener(readVo, excelWriter, writeSheet, paramsVo.getCreateAccount(), importExcelStrategy2)).sheet().headRowNumber(Integer.valueOf(crmExcelImport.startRow()))).doRead();
            failedNum = Integer.max(readVo.getFailedNum(), 0);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** \u5bfc\u5165\u51fa\u9519\u4e86 ****");
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("**** \u5bfc\u5165\u51fa\u9519\u4e86 ****");
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)String.format("\u5bfc\u5165\u51fa\u9519\u4e86:%s", e.getMessage()), (Object[])new Object[0]);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
            if (failedNum == 0) {
                FileUtil.del((File)errorFile);
            }
        }
        resultVo.setFailedNum(failedNum);
        return resultVo;
    }

    private Integer findExcelTotalRowIgnoreBlankLines(String path, int sheetNo) {
        EasyExcelListener easyExcelListener = new EasyExcelListener(true, BusinessConstant.IE_EXPORT_MAX_TOTAL);
        ExcelReader excelReader = EasyExcelFactory.read((String)path, (ReadListener)easyExcelListener).build().read(new ReadSheet[]{new ReadSheet(Integer.valueOf(sheetNo))});
        List list = easyExcelListener.getList(Object.class);
        int total = CollectionUtils.isEmpty((Collection)list) || list.size() == 0 ? excelReader.analysisContext().readRowHolder().getRowIndex() + 1 : list.size() + 1;
        excelReader.close();
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDetail(ExportTaskProcessVo task, ExportProcess process, Map<String, Object> paramsMap, String filePath) {
        ExcelWriter excelWriter = null;
        if (!FileUtil.exist((String)filePath)) {
            FileUtil.touch((String)filePath);
        }
        try {
            BusinessExportProcess exportProcess = (BusinessExportProcess)process;
            List excelHead = exportProcess.findHead(task, paramsMap);
            JSONArray data = process.getData(task, paramsMap);
            Validate.isTrue((Objects.nonNull(data) && !data.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e", (Object[])new Object[0]);
            Integer count = BzExcelUtil.findMsgCount((Integer)task.getPageSize());
            List<List<Object>> excelDataList = this.findExportData(data, process, task, paramsMap);
            Validate.isTrue((!CollectionUtils.isEmpty(excelDataList) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5bfc\u51fa\u6570\u636e", (Object[])new Object[0]);
            excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((String)filePath).head(excelHead)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
            WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
            String account = task.getCreateAccount();
            if (count <= 10) {
                excelWriter.write(excelDataList, writeSheet);
            } else {
                List result = Lists.partition(excelDataList, (int)count);
                int pageSize = result.size();
                int stepNum = 0;
                for (List item : result) {
                    excelWriter.write((Collection)item, writeSheet);
                    int cursor = ++stepNum * 100 / pageSize;
                    this.postStepWebSocketMsg(task, account, cursor);
                }
            }
            Thread.sleep(1000L);
            this.postStepWebSocketMsg(task, account, 100);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("**** \u5bfc\u51fa\u51fa\u9519\u4e86 ****");
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("**** \u5bfc\u51fa\u51fa\u9519\u4e86 ****");
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)"excel\u5bfc\u51fa\u51fa\u9519\u4e86", (Object[])new Object[0]);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
        }
    }

    private List<List<Object>> findExportData(JSONArray data, ExportProcess<?> process, ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        BusinessExportProcess exportProcess = (BusinessExportProcess)process;
        List fieldNames = exportProcess.findCrmExcelColumnField(task, paramsMap);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)fieldNames) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5b57\u6bb5\u914d\u7f6e", (Object[])new Object[0]);
        LinkedList list = Lists.newLinkedList();
        for (Object o : data) {
            JSONObject obj = JSONUtil.parseObj(o);
            LinkedList cur = Lists.newLinkedList();
            for (String fieldName : fieldNames) {
                Object filedValue = obj.getOrDefault((Object)fieldName, null);
                if (filedValue == null) {
                    String fieldNameByLowerCamel = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
                    filedValue = obj.getOrDefault((Object)fieldNameByLowerCamel, null);
                }
                cur.add(filedValue);
            }
            list.add(cur);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> merge(ExportTaskProcessVo task, ExportProcess process, String parentPath, List<ExportTaskDetailVo> list, Map<String, String> tmpFileMap) {
        Validate.isTrue((Objects.nonNull(task) && StringUtils.isNotBlank((CharSequence)task.getTaskCode()) ? 1 : 0) != 0, (String)"\u5bfc\u51fa\u4e3b\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String taskCode = task.getTaskCode();
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u5b50\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        for (ExportTaskDetailVo item : list) {
            String s = tmpFileMap.get(item.getDetailCode());
            Validate.notBlank((CharSequence)s, (String)CharSequenceUtil.format((CharSequence)"{}\u5b50\u4efb\u52a1\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Object[])new Object[]{item.getDetailCode()}), (Object[])new Object[0]);
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (list.size() == 1) {
            map.put(taskCode + ".xlsx", tmpFileMap.get(list.get(0).getDetailCode()));
            return map;
        }
        Integer maxSize = this.importExportProperties.getExportProperties().getExcelMaxCount();
        Integer pageSize = list.get(0).getPageSize();
        Validate.isTrue((maxSize > pageSize ? 1 : 0) != 0, (String)"\u6700\u5927\u5bfc\u51fa\u6570\u5fc5\u987b\u5927\u4e8e\u5904\u7406\u5668\u9875\u6570", (Object[])new Object[0]);
        int splitSize = maxSize / pageSize;
        Integer i = 0;
        int cursor = 0;
        Integer size = list.size();
        int startRow = 1;
        String businessCode = task.getBusinessCode();
        BusinessExportProcess exportProcess = (BusinessExportProcess)process;
        List excelHead = exportProcess.findHead(task, this.findParamsMap(task));
        List partition = Lists.partition(list, (int)splitSize);
        for (List item : partition) {
            ExportTask exportTaskTemp;
            ExcelWriter excelWriter = null;
            String fileName = CharSequenceUtil.format((CharSequence)"\u4e3b\u6587\u4ef6_{}_{}_{}{}", (Object[])new Object[]{task.getTaskSource(), taskCode, i, ".xlsx"});
            String fileTempName = process.getTaskFileName(task);
            if (StringUtils.isNotBlank((CharSequence)fileTempName)) {
                fileName = CharSequenceUtil.format((CharSequence)"{}_{}{}", (Object[])new Object[]{fileTempName, i, ".xlsx"});
            }
            if (ObjectUtils.isNotEmpty((Object)(exportTaskTemp = this.exportTaskRepository.findByTaskCode(taskCode)))) {
                fileName = exportTaskTemp.getFileName();
            }
            try {
                excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcelFactory.write((String)(parentPath + fileName)).head(excelHead)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
                WriteSheet writeSheet = EasyExcelFactory.writerSheet((String)"Sheet1").build();
                for (ExportTaskDetailVo detail : item) {
                    Integer count = BzExcelUtil.findMsgCount((Integer)detail.getPageSize());
                    String curPath = tmpFileMap.get(detail.getDetailCode());
                    Validate.isTrue((FileUtil.exist((String)curPath) && FileUtil.size((File)FileUtil.file((String)curPath)) > 0L ? 1 : 0) != 0, (String)CharSequenceUtil.format((CharSequence)"\u672a\u52a0\u8f7d\u5230\u5b50\u4efb\u52a1{}\u5bf9\u5e94\u7684\u6587\u4ef6", (Object[])new Object[]{detail.getDetailCode()}), (Object[])new Object[0]);
                    ((ExcelReaderSheetBuilder)EasyExcelFactory.read((String)curPath, (ReadListener)new CrmExportExcelReadListener(count, excelWriter, writeSheet)).sheet().headRowNumber(Integer.valueOf(startRow))).doRead();
                    this.sendExportMergeProcessMsg(++cursor, size, task.getTaskCode());
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
                log.error("**** \u81ea\u5b9a\u4e49-\u5bfc\u51fa\u51fa\u9519\u4e86 ****");
                log.error(e.getMessage(), (Throwable)e);
                Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("**** \u81ea\u5b9a\u4e49-\u5bfc\u51fa\u51fa\u9519\u4e86 ****");
                log.error(e.getMessage(), (Throwable)e);
                Validate.isTrue((boolean)false, (String)"\u5bfc\u51fa\u51fa\u9519\u4e86", (Object[])new Object[0]);
            }
            finally {
                if (excelWriter != null) {
                    excelWriter.close();
                }
                map.put(fileName, parentPath + fileName);
            }
            Integer n = i;
            i = i + 1;
            Integer n2 = i;
        }
        return map;
    }

    private Map<String, Object> findParamsMap(ExportTaskProcessVo task) {
        if (Objects.isNull(task) || StringUtils.isBlank((CharSequence)task.getParametersJson())) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        JSONObject jsonObject = JSONUtil.parseObj((String)task.getParametersJson());
        Set set = jsonObject.keySet();
        for (String item : set) {
            map.put(item, jsonObject.get((Object)item));
        }
        return map;
    }

    private void sendExportMergeProcessMsg(Integer cursor, Integer size, String taskCode) {
        Integer n = 40 + cursor * 40 / size;
        ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
        msgVo.setTaskCode(taskCode);
        msgVo.setMainFlag(Boolean.valueOf(true));
        msgVo.setIsCombine(Boolean.valueOf(true));
        msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        msgVo.setProcessType(ExportProcessEnum.COMBINE.getCode());
        msgVo.setRemark(CharSequenceUtil.format((CharSequence)"\u4efb\u52a1{},\u603b\u8ba1{}\u4e2a\u5b50\u4efb\u52a1,\u5df2\u5408\u5e76{}\u4e2a", (Object[])new Object[]{taskCode, size, cursor}));
        msgVo.setPageSize(Integer.valueOf(100));
        msgVo.setAccount(this.loginUserService.getLoginAccountName());
        msgVo.setCursor(n);
        this.exportSendProcessMsgBean.sendMsg(msgVo);
    }

    private void postStepWebSocketMsg(ExportTaskProcessVo task, String account, int cursor) {
        this.postStepWebSocketMsg(task, account, cursor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postStepWebSocketMsg(ExportTaskProcessVo task, String account, int cursor, Boolean mainFlag) {
        try {
            log.info("\u5bfc\u51fa\u4fe1\u606ftask[{}],account[{}],cursor[{}],mainFlag[{}]", new Object[]{JSON.toJSONString((Object)task), account, cursor, mainFlag});
            this.exportSendProcessMsgBean.sendTaskProcessMsg(task, ExecStatusEnum.RUNNING.getValue(), ExportProcessEnum.RUNNING, Integer.valueOf(cursor), account, mainFlag);
        }
        catch (NullPointerException e) {
            log.error("\u63a8\u9001\u8fdb\u5ea6\u6d88\u606f\u9519\u8bef");
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ThreadUtil.sleep((long)50L);
        }
    }
}

