/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.ie.local;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.biz.crm.business.common.ie.sdk.process.BusinessImportProcess;
import com.biz.crm.business.common.ie.sdk.vo.BusinessCrmExcelVo;
import com.biz.crm.common.ie.local.model.vo.ImportExcelReadModelVo;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.strategy.ImportExcelStrategy;
import com.biz.crm.common.ie.sdk.vo.ExcelItemVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessCrmImportExcelReadListener
extends AnalysisEventListener<Map<Integer, Object>> {
    private static final Logger log = LoggerFactory.getLogger(BusinessCrmImportExcelReadListener.class);
    private ImportExcelReadModelVo readVo;
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private Integer failedNum = 0;
    private Integer successNum = 0;
    private Integer cursor = 0;
    private Map<Integer, String> headFieldMap = Maps.newHashMap();
    private Map<Integer, String> headMap = Maps.newHashMap();
    private List<List<Object>> cachedDataList = Lists.newLinkedList();
    private Map<Integer, String> cacheErr = Maps.newHashMap();
    private LinkedHashMap<Integer, CrmExcelVo> cacheData = Maps.newLinkedHashMap();
    private Integer cacheCursor = 0;
    private String account;
    private ImportExcelStrategy importExcelStrategy;
    private boolean hasWriteErrorHead = false;

    public BusinessCrmImportExcelReadListener(ImportExcelReadModelVo readVo, ExcelWriter excelWriter, WriteSheet writeSheet, String account, ImportExcelStrategy importExcelStrategy) {
        this.readVo = readVo;
        this.excelWriter = excelWriter;
        this.writeSheet = writeSheet;
        this.account = account;
        this.importExcelStrategy = importExcelStrategy;
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        super.invokeHeadMap(headMap, context);
        Integer rowIndex = context.readRowHolder().getRowIndex();
        BusinessImportProcess process = (BusinessImportProcess)this.readVo.getProcess();
        if (!Objects.equals(process.getHeadTitleRowIndex(), rowIndex)) {
            return;
        }
        this.headMap = headMap;
        try {
            this.headFieldMap = process.analysisHeadFieldMap(this.readVo.getParams(), headMap);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void invoke(Map<Integer, Object> data, AnalysisContext context) {
        Serializable headVlueMap;
        if (this.readVo.getProcess().getBatchCount().compareTo(0) <= 0) {
            return;
        }
        if (this.cacheCursor.equals(this.readVo.getProcess().getBatchCount())) {
            this.execute();
        }
        List<Object> cur = this.findData(data);
        this.cachedDataList.add(cur);
        Integer n = this.cursor;
        Integer n2 = this.cursor = Integer.valueOf(this.cursor + 1);
        try {
            BusinessCrmExcelVo o = (BusinessCrmExcelVo)this.readVo.getProcess().findCrmExcelVoClass().newInstance();
            headVlueMap = Maps.newHashMap();
            for (Map.Entry<Integer, Object> entry : data.entrySet()) {
                String filedTitle = this.headMap.get(entry.getKey());
                headVlueMap.put(filedTitle, entry.getValue());
            }
            o.setHeadFiledMap((Map)((Object)headVlueMap));
            this.setCrmExcelMapValue(o, data);
            Integer n3 = this.cacheCursor;
            Integer n4 = this.cacheCursor = Integer.valueOf(this.cacheCursor + 1);
            this.cacheData.put(n3, (CrmExcelVo)o);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error(e.getMessage(), (Throwable)e);
            cur.add(e.getMessage());
            headVlueMap = this.cacheCursor;
            Integer n5 = this.cacheCursor = Integer.valueOf(this.cacheCursor + 1);
            this.cacheErr.put((Integer)headVlueMap, e.getMessage());
            this.failedNum = this.failedNum + 1;
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(baos));
            String exception = baos.toString();
            log.error("\u9519\u8bef\u65e5\u5fd7:{},\u9519\u8bef\u5806\u6808:{}", (Object)e.getMessage(), (Object)exception);
            cur.add("\u6570\u636e\u5f02\u5e38:" + e.getMessage() + "\u3001" + exception);
            Integer n6 = this.cacheCursor;
            Integer n7 = this.cacheCursor = Integer.valueOf(this.cacheCursor + 1);
            this.cacheErr.put(n6, "\u6570\u636e\u5f02\u5e38:" + e.getMessage() + "\u3001" + exception);
            this.failedNum = this.failedNum + 1;
            log.error(e.getMessage(), (Throwable)e);
        }
        this.sendProcessMsg(true);
    }

    public void setCrmExcelMapValue(BusinessCrmExcelVo o, Map<Integer, Object> data) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        if (this.headFieldMap != null && !this.headFieldMap.isEmpty()) {
            HashMap dataMap = Maps.newHashMap();
            for (Map.Entry<Integer, Object> entry : data.entrySet()) {
                String headField = this.headFieldMap.get(entry.getKey());
                if (!StringUtils.isNotEmpty((CharSequence)headField)) continue;
                dataMap.put(headField, entry.getValue());
            }
            o.setData((Map)dataMap);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.execute();
        this.sendProcessMsg(false);
        this.readVo.setSuccessNum(this.successNum.intValue());
        this.readVo.setFailedNum(this.failedNum.intValue());
    }

    private void execute() {
        Object object;
        if (this.cacheData == null || this.cacheData.isEmpty()) {
            return;
        }
        Map map = null;
        try {
            map = this.readVo.getProcess().execute(this.cacheData, this.readVo.getParamsVo(), this.readVo.getParams());
            Set<Integer> set = this.cacheData.keySet();
            map = Optional.ofNullable(map).orElse(Maps.newHashMap());
            Map finalMap = map;
            long count = set.stream().filter(a -> !finalMap.keySet().contains(a)).count();
            this.successNum = this.successNum + Integer.parseInt(count + "");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("\u6570\u636e\u5904\u7406\u5f02\u5e38\u4fe1\u606f\u5c55\u793a:");
            log.error(e.getMessage(), (Throwable)e);
            for (Integer item : this.cacheData.keySet()) {
                this.cacheErr.put(item, e.getMessage());
                object = this.failedNum;
                Integer n = this.failedNum = Integer.valueOf(this.failedNum + 1);
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(baos));
            String exception = baos.toString();
            log.error("\u6570\u636e\u5904\u7406\u5f02\u5e38\u4fe1\u606f\u5c55\u793a:");
            log.error("\u9519\u8bef\u65e5\u5fd7:{},\u9519\u8bef\u5806\u6808:{}", (Object)e.getMessage(), (Object)exception);
            log.error(e.getMessage(), (Throwable)e);
            for (Integer item : this.cacheData.keySet()) {
                this.cacheErr.put(item, "\u6570\u636e\u5904\u7406\u5f02\u5e38:" + exception);
                Integer n = this.failedNum;
                Integer n2 = this.failedNum = Integer.valueOf(this.failedNum + 1);
            }
        }
        if (map != null && !map.isEmpty()) {
            for (Map.Entry item : map.entrySet()) {
                this.cacheErr.put((Integer)item.getKey(), (String)item.getValue());
                Integer n = this.failedNum;
                this.failedNum = this.failedNum + 1;
                object = this.failedNum;
            }
        }
        this.writeErrorExcel();
        this.resetCache();
    }

    private void writeErrorExcel() {
        int i = 0;
        LinkedList errDataList = Lists.newLinkedList();
        for (List<Object> item : this.cachedDataList) {
            String s = this.cacheErr.get(i);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                item.add(s);
                errDataList.add(item);
            }
            ++i;
        }
        if (CollectionUtils.isEmpty((Collection)errDataList)) {
            return;
        }
        if (!this.hasWriteErrorHead) {
            List headFieldList = this.headMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
            errDataList.add(0, headFieldList);
            this.hasWriteErrorHead = true;
        }
        this.excelWriter.write((Collection)errDataList, this.writeSheet);
    }

    private List<Object> findData(Map<Integer, Object> data) {
        if (data == null || data.isEmpty()) {
            return Lists.newLinkedList();
        }
        LinkedList items = Lists.newLinkedList();
        for (Map.Entry<Integer, Object> item : data.entrySet()) {
            ExcelItemVo cur = new ExcelItemVo();
            cur.setColumn(item.getKey());
            cur.setData(item.getValue());
            items.add(cur);
        }
        return items.stream().sorted(Comparator.comparing(ExcelItemVo::getColumn)).map(ExcelItemVo::getData).collect(Collectors.toList());
    }

    private void resetCache() {
        this.cacheCursor = 0;
        this.cachedDataList = Lists.newLinkedList();
        this.cacheErr = Maps.newHashMap();
        this.cacheData = Maps.newLinkedHashMap();
    }

    private void sendProcessMsg(Boolean processFlag) {
        if (Boolean.TRUE.equals(processFlag) && this.cursor % 10 != 0) {
            return;
        }
        log.info("\u4efb\u52a1{},\u7b2c1\u9875,\u603b\u8ba1{},\u5f53\u524d\u8fdb\u5ea6{},\u6210\u529f{},\u5931\u8d25{}", new Object[]{this.readVo.getParamsVo().getTaskCode(), this.readVo.getTotal(), this.cursor, this.successNum, this.failedNum});
        this.readVo.getMsgBean().sendProcessMsg(this.readVo.getParamsVo().getTaskCode(), Integer.valueOf(this.readVo.getTotal()), this.cursor, this.successNum, this.failedNum, this.account);
    }
}

