/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.ie.local;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.base.util.UuidCrmUtil;
import com.biz.crm.business.common.ie.sdk.dto.DynamicHeadExportDto;
import com.biz.crm.business.common.ie.sdk.vo.DynamicHeadExportConfigVo;
import com.biz.crm.business.common.ie.sdk.vo.DynamicHeadExportVo;
import com.biz.crm.business.common.ie.sdk.vo.ExportConfigVo;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.MultipartFileUtil;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.repository.ImportTaskRepository;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.LoadStatusEnum;
import com.biz.crm.common.rulecode.sdk.service.GenerateCodeRuleVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class BusinessExcelExportTemplateWriteUtil {
    private static final Logger log = LoggerFactory.getLogger(BusinessExcelExportTemplateWriteUtil.class);
    @Value(value="${export.custom.path:/home/crm/temp/xlsx/}")
    private String FILE_PATH;
    @Value(value="${spring.application.name:}")
    private String subsystem;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Resource
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private GenerateCodeRuleVoService generateCodeRuleVoService;
    @Resource
    private ImportTaskRepository importTaskRepository;
    private static final String ERR_MSG_FORMAT = "{}\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25";

    public String exportExcelByTemplate(String templateFilePath, String outputFileName, Map<String, List<?>> map, String replaceHeadName) {
        outputFileName = outputFileName.replace("/", "\u6216");
        if (ObjectUtils.isNotEmpty((Object)replaceHeadName)) {
            replaceHeadName = replaceHeadName.replace("/", "\u6216");
        }
        this.copyExcelTemplate(templateFilePath, outputFileName);
        String fileCode = this.writeExcelTemplate(map, outputFileName, replaceHeadName);
        return fileCode;
    }

    private void copyExcelTemplate(String templateFilePath, String outputFileName) {
        boolean success;
        InputStream templateInputStream = BusinessExcelExportTemplateWriteUtil.class.getClassLoader().getResourceAsStream(templateFilePath);
        FileOutputStream outputStream = null;
        File folder = new File(this.FILE_PATH);
        if (!folder.exists() && !(success = folder.mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25:" + this.FILE_PATH);
        }
        String outputFilePath = this.FILE_PATH + outputFileName + ExcelTypeEnum.XLSX.getValue();
        try {
            int bytesRead;
            outputStream = new FileOutputStream(outputFilePath);
            if (templateInputStream == null) {
                throw new RuntimeException("\u65e0\u6cd5\u627e\u5230 Excel \u6a21\u677f\u6587\u4ef6: " + templateFilePath);
            }
            byte[] buffer = new byte[1024];
            while ((bytesRead = templateInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u590d\u5236\u51fa\u9519:" + e.getMessage());
        }
        finally {
            this.closeStream(templateInputStream, "InputStream");
            this.closeStream(outputStream, "FileOutputStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeExcelTemplate(Map<String, List<?>> map, String outputFileName, String replaceHeadName) {
        ExcelWriter excelWriter = null;
        String templateFilePath = this.FILE_PATH + outputFileName + ExcelTypeEnum.XLSX.getValue();
        String newFileName = outputFileName + "_" + System.currentTimeMillis() + ExcelTypeEnum.XLSX.getValue();
        String outputFilePath = this.FILE_PATH + newFileName;
        try {
            File templateFile = new File(templateFilePath);
            if (!templateFile.exists()) {
                throw new RuntimeException("Excel \u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728: " + templateFilePath);
            }
            try {
                FileUtils.copyFile((File)new File(templateFilePath), (File)new File(outputFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            excelWriter = EasyExcel.write((String)outputFilePath).withTemplate(templateFilePath).build();
            for (Map.Entry<String, List<?>> l : map.entrySet()) {
                WriteSheet tpWriteSheet = EasyExcel.writerSheet((String)l.getKey()).build();
                excelWriter.write((Collection)l.getValue(), tpWriteSheet);
            }
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
        if (ObjectUtils.isNotEmpty((Object)replaceHeadName)) {
            // empty if block
        }
        String fileCode = this.uploadFile(outputFilePath, newFileName);
        this.deleteFile(templateFilePath);
        this.deleteFile(outputFilePath);
        return fileCode;
    }

    private void replaceHeaderText(String filePath, String replacementText) throws IOException {
        try (Workbook workbook = WorkbookFactory.create((File)new File(filePath));){
            Sheet sheet = workbook.getSheetAt(0);
            Row headerRow = sheet.getRow(0);
            for (Cell cell : headerRow) {
                String cellValue = cell.getStringCellValue();
                cell.setCellValue(replacementText);
            }
            try (FileOutputStream fileOut = new FileOutputStream(filePath);){
                workbook.write((OutputStream)fileOut);
            }
        }
    }

    private void closeStream(Closeable stream, String streamName) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed {} \u51fa\u9519", (Object)streamName);
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void deleteFile(String filePath) {
        File outputFile = new File(filePath);
        if (outputFile.exists() && outputFile.isFile()) {
            outputFile.delete();
        }
    }

    private String uploadFile(String filePath, String fileName) {
        boolean exist = FileUtil.exist((String)filePath);
        Validate.isTrue((boolean)exist, (String)CharSequenceUtil.format((CharSequence)"{}\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[]{fileName}), (Object[])new Object[0]);
        String fileCode = null;
        try (BufferedInputStream is = FileUtil.getInputStream((String)filePath);){
            MultipartFile multipartFile = MultipartFileUtil.getMultipartFile((InputStream)is, (String)fileName);
            OrdinaryFileVo ordinaryFileVo = this.venusFileUpload(multipartFile).get(0);
            fileCode = ordinaryFileVo.getId();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faZIP\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,error[{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
            log.error(e.getMessage(), (Throwable)e);
            Validate.isTrue((boolean)false, (String)CharSequenceUtil.format((CharSequence)ERR_MSG_FORMAT, (Object[])new Object[]{fileName}), (Object[])new Object[0]);
        }
        return fileCode;
    }

    public List<OrdinaryFileVo> venusFileUpload(MultipartFile multipartFile) throws IOException {
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setCreator(this.loginUserService.findCurrentAccount());
        base64UploadDto.setFileNanmes(new String[]{multipartFile.getOriginalFilename()});
        base64UploadDto.setBase64Contents(new String[]{Base64Utils.encodeToString((byte[])multipartFile.getBytes())});
        List ordinaryFileVoList = this.fileHandleService.fileUpload(this.subsystem.replace("-", "_"), base64UploadDto, null);
        Validate.notEmpty((Collection)ordinaryFileVoList, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Object[])new Object[0]);
        return ordinaryFileVoList;
    }

    public void saveUploadFileImport(MultipartFile multipartFile, ImportTask importTask) {
        OrdinaryFileVo ordinaryFileVo = this.venusFileUpload(multipartFile).get(0);
        String fileCode = ordinaryFileVo.getId();
        importTask.setFileCode(fileCode);
        importTask.setAppCode(TenantUtils.getTenantCode());
        importTask.setApplicationName(this.importExportProperties.getIeTaskGroup());
        importTask.setTenantCode(TenantUtils.getTenantCode());
        importTask.setTaskCode(this.generateCodeRuleVoService.generateCode("IT"));
        importTask.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
        importTask.setLoadStatus(LoadStatusEnum.YES.getDictCode());
        this.importTaskRepository.save((Object)importTask);
    }

    public String writeExcelDynamicHeadConfig(DynamicHeadExportDto dto) {
        return this.writeExcelDynamicHead(dto.getOutputFileName(), this.covert(dto.getMap(), dto.getDictMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeExcelDynamicHead(String outputFileName, Map<String, DynamicHeadExportVo> map) {
        if (StringUtils.isBlank((CharSequence)outputFileName)) {
            outputFileName = UuidCrmUtil.randomUuid();
        }
        if (MapUtils.isEmpty(map)) {
            return "";
        }
        ExcelWriter excelWriter = null;
        String newFileName = outputFileName + "_" + System.currentTimeMillis() + ExcelTypeEnum.XLSX.getValue();
        String outputFilePath = this.FILE_PATH + newFileName;
        this.dealPath(newFileName);
        try {
            excelWriter = EasyExcel.write((String)outputFilePath).build();
            for (Map.Entry<String, DynamicHeadExportVo> l : map.entrySet()) {
                DynamicHeadExportVo vo = l.getValue();
                if (Objects.isNull(vo) || CollectionUtils.isEmpty((Collection)vo.getHeadList()) || CollectionUtils.isEmpty((Collection)vo.getValues())) continue;
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)l.getKey()).head(vo.getHeadList().stream().map(xva$0 -> Lists.newArrayList((Object[])new String[]{xva$0})).collect(Collectors.toList()))).build();
                excelWriter.write((Collection)vo.getValues(), writeSheet);
            }
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
        String fileCode = this.uploadFile(outputFilePath, newFileName);
        this.deleteFile(outputFilePath);
        return fileCode;
    }

    private Map<String, DynamicHeadExportVo> covert(Map<String, DynamicHeadExportConfigVo> map, Map<String, Map<String, String>> dictMap) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        HashMap<String, DynamicHeadExportVo> result = new HashMap<String, DynamicHeadExportVo>(map.size());
        map.forEach((key, configVo) -> {
            List<ExportConfigVo> configList = configVo.getConfigList();
            if (CollectionUtils.isEmpty((Collection)configList) || CollectionUtils.isEmpty((Collection)configVo.getJsonArray())) {
                return;
            }
            if (CollectionUtils.isEmpty(configList = configList.stream().filter(v -> Objects.nonNull(v.getExports()) && Objects.nonNull(v.getFormorder()) && v.getExports() != false).sorted(Comparator.comparingInt(ExportConfigVo::getFormorder)).collect(Collectors.toList()))) {
                return;
            }
            List<List<?>> list = this.buildData(configList, configVo.getJsonArray(), dictMap);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            DynamicHeadExportVo vo = new DynamicHeadExportVo();
            vo.setHeadList(configList.stream().map(ExportConfigVo::getTitle).collect(Collectors.toList()));
            vo.setValues(list);
            result.put((String)key, vo);
        });
        return result;
    }

    private List<List<?>> buildData(List<ExportConfigVo> sorted, JSONArray jsonArray, Map<String, Map<String, String>> dictMap) {
        ArrayList list = new ArrayList(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            List row = sorted.stream().map(v -> {
                String value = jsonObject.getString(v.getField());
                if (dictMap.containsKey(v.getDictCode())) {
                    return (String)((Map)dictMap.get(v.getDictCode())).get(value);
                }
                return value;
            }).collect(Collectors.toList());
            list.add(row);
        }
        return list;
    }

    private void dealPath(String newFileName) {
        File file;
        File path = new File(this.FILE_PATH);
        if (!path.exists()) {
            Validate.isTrue((boolean)path.mkdirs(), (String)"\u6587\u4ef6\u8def\u5f84\u521b\u5efa\u5931\u8d25", (Object[])new Object[0]);
        }
        if (!(file = new File(this.FILE_PATH + newFileName)).exists()) {
            try {
                Validate.isTrue((boolean)file.createNewFile(), (String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff1a%s", (Object[])new Object[]{newFileName});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

