/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.ie.local;

import com.biz.crm.business.common.ie.local.BusinessCrmExcelImportExportProcessStrategy;
import com.biz.crm.business.common.ie.sdk.process.BusinessExportProcess;
import com.biz.crm.business.common.ie.sdk.process.BusinessImportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.ImportExcelLocalFile;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BusinessExcelImportExportProcessAspect {
    private static final Logger log = LoggerFactory.getLogger(BusinessExcelImportExportProcessAspect.class);
    @Autowired
    private BusinessCrmExcelImportExportProcessStrategy businessCrmExcelImportExportProcessStrategy;

    @Around(value="execution(com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy.importExcel(..,com.biz.crm.common.ie.sdk.vo.ImportExcelLocalFile))")
    public Object doBeforeImport(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        ImportProcess process = (ImportProcess)args[0];
        if (args.length != 4) {
            return joinPoint.proceed();
        }
        if (!(process instanceof BusinessImportProcess)) {
            return joinPoint.proceed();
        }
        if (!(args[3] instanceof ImportExcelLocalFile)) {
            return joinPoint.proceed();
        }
        TaskGlobalParamsVo paramsVo = (TaskGlobalParamsVo)args[1];
        Map params = (Map)args[2];
        ImportExcelLocalFile localFile = (ImportExcelLocalFile)args[3];
        Map fileMap = localFile.convertFileMap();
        return this.businessCrmExcelImportExportProcessStrategy.importExcel((ImportProcess<CrmExcelVo>)process, paramsVo, params, fileMap);
    }

    @Around(value="execution(void com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy.exportDetail(..))")
    public void doBeforeExport(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        ExportProcess process = (ExportProcess)args[1];
        if (!(process instanceof BusinessExportProcess)) {
            joinPoint.proceed();
            return;
        }
        ExportTaskProcessVo task = (ExportTaskProcessVo)args[0];
        Map paramsMap = (Map)args[2];
        String filePath = (String)args[3];
        this.businessCrmExcelImportExportProcessStrategy.exportDetail(task, process, paramsMap, filePath);
    }

    @Around(value="execution(* com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy.merge(..))")
    public Object doBeforeMerge(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        ExportProcess process = (ExportProcess)args[1];
        if (!(process instanceof BusinessExportProcess)) {
            return joinPoint.proceed();
        }
        ExportTaskProcessVo task = (ExportTaskProcessVo)args[0];
        String parentPath = (String)args[2];
        List list = (List)args[3];
        Map tmpFileMap = (Map)args[4];
        return this.businessCrmExcelImportExportProcessStrategy.merge(task, process, parentPath, list, tmpFileMap);
    }
}

