/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.ie.local;

import cn.hutool.core.io.FileUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.biz.crm.business.common.base.vo.ExportWriteMdmVo;
import com.biz.crm.business.common.ie.local.BusinessExcelExportTemplateWriteUtil;
import com.biz.crm.business.common.sdk.utils.MultipartFileUtil;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class BusinessExcelWriteMdmDataUtil {
    private static final Logger log = LoggerFactory.getLogger(BusinessExcelWriteMdmDataUtil.class);
    @Value(value="${export.custom.path:/home/crm/temp/xlsx/}")
    private String FILE_PATH;
    @Value(value="${spring.application.name:}")
    private String subsystem;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    private static final String ERR_MSG_FORMAT = "{}\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25";
    private static final String TEMPLATE_TEMP_NAME = "temp";
    @Resource
    private BusinessExcelExportTemplateWriteUtil writeUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeMdmDataToExcel(Map<String, Integer> sheetMap, String fileId, Map<String, List<? extends ExportWriteMdmVo>> map) throws IOException {
        String fileCode = null;
        String templateFilePath = null;
        String outputFilePath = null;
        try {
            OrdinaryFileVo fileVo = this.fileHandleService.findById(fileId);
            String templateFileName = TEMPLATE_TEMP_NAME + fileVo.getOriginalFileName();
            templateFilePath = this.FILE_PATH + templateFileName;
            String outputFileName = fileVo.getOriginalFileName();
            outputFilePath = this.FILE_PATH + fileVo.getOriginalFileName();
            byte[] bytes = this.fileHandleService.findContentByFilePathAndFileRename(fileVo.getRelativeLocal(), fileVo.getFileName());
            if (bytes != null) {
                FileUtil.writeBytes((byte[])bytes, (String)templateFilePath);
            }
            try {
                XSSFWorkbook workbook = new XSSFWorkbook(templateFilePath);
                Object object = null;
                try {
                    Iterator iterator = workbook.sheetIterator();
                    while (iterator.hasNext()) {
                        Sheet sheet = (Sheet)iterator.next();
                        for (Map.Entry<String, Integer> sheetEntry : sheetMap.entrySet()) {
                            if (!sheet.getSheetName().equals(sheetEntry.getKey())) continue;
                            for (int i = sheet.getPhysicalNumberOfRows() - 1; i >= sheetEntry.getValue(); --i) {
                                Row row = sheet.getRow(i);
                                if (row == null) continue;
                                sheet.removeRow(row);
                            }
                        }
                    }
                    FileOutputStream fileOut = new FileOutputStream(outputFilePath);
                    Object object2 = null;
                    try {
                        workbook.write((OutputStream)fileOut);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fileOut != null) {
                            if (object2 != null) {
                                try {
                                    fileOut.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                fileOut.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (workbook != null) {
                        if (object != null) {
                            try {
                                workbook.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            workbook.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ExcelWriter excelWriter = EasyExcel.write((String)outputFilePath).withTemplate(templateFilePath).build();
            for (Map.Entry entry : map.entrySet()) {
                WriteSheet tpWriteSheet = EasyExcel.writerSheet((String)((String)entry.getKey())).build();
                List<List<? extends ExportWriteMdmVo>> partitionList = BusinessExcelWriteMdmDataUtil.paginateList((List)entry.getValue(), 10);
                for (List<? extends ExportWriteMdmVo> list : partitionList) {
                    excelWriter.write(list, tpWriteSheet);
                }
            }
            excelWriter.finish();
            BufferedInputStream is = FileUtil.getInputStream((String)outputFilePath);
            MultipartFile multipartFile = MultipartFileUtil.getMultipartFile((InputStream)is, (String)outputFileName);
            OrdinaryFileVo ordinaryFileVo = this.writeUtil.venusFileUpload(multipartFile).get(0);
            fileCode = ordinaryFileVo.getId();
        }
        catch (Throwable throwable) {
            FileUtil.del(templateFilePath);
            FileUtil.del(outputFilePath);
            throw throwable;
        }
        FileUtil.del((String)templateFilePath);
        FileUtil.del((String)outputFilePath);
        return fileCode;
    }

    private static List<List<? extends ExportWriteMdmVo>> paginateList(List<? extends ExportWriteMdmVo> list, int pageSize) {
        ArrayList<List<? extends ExportWriteMdmVo>> pages = new ArrayList<List<? extends ExportWriteMdmVo>>();
        for (int i = 0; i < list.size(); i += pageSize) {
            pages.add(new ArrayList<ExportWriteMdmVo>(list.subList(i, Math.min(i + pageSize, list.size()))));
        }
        return pages;
    }
}

