/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.ie.local;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.base.util.BusinessBeanUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessMoreSheetImportListener
extends AnalysisEventListener<Map<Integer, String>> {
    private static final Logger log = LoggerFactory.getLogger(BusinessMoreSheetImportListener.class);
    private Map<Integer, String> headMap = Maps.newHashMap();
    private Integer startRow;
    private List<Map<String, Object>> headFiledList = new LinkedList<Map<String, Object>>();

    public BusinessMoreSheetImportListener(Integer startRow) {
        this.startRow = startRow;
    }

    public void onException(Exception exception, AnalysisContext context) {
        log.error("\u89e3\u6790\u5931\u8d25\uff0c\u4f46\u662f\u7ee7\u7eed\u89e3\u6790\u4e0b\u4e00\u884c:{}", (Object)exception.getMessage());
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            throw new RuntimeException(String.format("\u7b2c%s\u884c\uff0c\u7b2c%s\u5217\u89e3\u6790\u5f02\u5e38\uff0c\u6570\u636e\u4e3a:%s", excelDataConvertException.getRowIndex(), excelDataConvertException.getColumnIndex(), excelDataConvertException.getCellData()));
        }
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u5934\u6570\u636e:{}", (Object)JSON.toJSONString(headMap));
        this.headMap = headMap;
    }

    public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString(data));
        HashMap headFiledMap = Maps.newHashMap();
        for (Map.Entry<Integer, String> entry : this.headMap.entrySet()) {
            String filedTitle = entry.getValue();
            String value = data.get(entry.getKey());
            headFiledMap.put(filedTitle, value);
        }
        this.headFiledList.add(headFiledMap);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public <T> List<T> transObjectToClazz(Class<T> clazz, Map<String, String> filedMap, Map<String, Boolean> filedCheckMap, String templateName) {
        ArrayList resultList = Lists.newArrayList();
        Integer count = 1;
        for (Map<String, Object> objectMap : this.headFiledList) {
            if (this.startRow >= count) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                continue;
            }
            HashMap map = Maps.newHashMap();
            StringJoiner errMsg = new StringJoiner(";");
            for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                Validate.isTrue((boolean)filedMap.containsKey(entry.getKey()), (String)String.format("\u6a21\u7248%s\u672a\u914d\u7f6e\u5b57\u6bb5%s", templateName, entry.getKey()), (Object[])new Object[0]);
                if (filedCheckMap == null || !filedCheckMap.isEmpty()) {
                    // empty if block
                }
                String filed = filedMap.get(entry.getKey());
                Object object = entry.getValue();
                if (Objects.nonNull(object) && "ERROR".equalsIgnoreCase(object.toString())) {
                    object = null;
                }
                map.put(filed, ObjectUtils.defaultIfNull((Object)object, (Object)""));
            }
            resultList.add(map);
        }
        this.headFiledList.clear();
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return Lists.newArrayList();
        }
        return BusinessBeanUtils.mapListToBeanList((List)resultList, clazz, (boolean)Boolean.TRUE);
    }

    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    public Integer getStartRow() {
        return this.startRow;
    }

    public List<Map<String, Object>> getHeadFiledList() {
        return this.headFiledList;
    }

    public void setHeadMap(Map<Integer, String> headMap) {
        this.headMap = headMap;
    }

    public void setStartRow(Integer startRow) {
        this.startRow = startRow;
    }

    public void setHeadFiledList(List<Map<String, Object>> headFiledList) {
        this.headFiledList = headFiledList;
    }
}

