package com.biz.crm.business.common.ie.sdk.process;

import com.biz.crm.business.common.base.constant.BusinessConstant;
import com.biz.crm.business.common.ie.sdk.vo.BusinessCrmExcelExportVo;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;

import java.util.List;
import java.util.Map;

public abstract class BusinessExportProcess implements ExportProcess<BusinessCrmExcelExportVo> {


    @Override
    public Integer getPageSize(){
        return BusinessConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Class<BusinessCrmExcelExportVo> findCrmExcelVoClass() {
        return BusinessCrmExcelExportVo.class;
    }

    /**
     * 解析表头字段
     * @param task 导出任务参数
     * @param paramsMap 请求参数
     * @return 表头对应字段名
     */
    public abstract List<List<String>> findHead(ExportTaskProcessVo task, Map<String, Object> paramsMap);

    /**
     * 获取字段配置
     * @param task 导出任务参数
     * @param paramsMap 请求参数
     */
    public abstract List<String> findCrmExcelColumnField(ExportTaskProcessVo task, Map<String, Object> paramsMap) ;

}
