package com.biz.crm.business.common.ie.sdk.dto;

import com.biz.crm.business.common.ie.sdk.vo.DynamicHeadExportConfigVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @Description 动态头导出dto
 * @Author chenzhuo
 * @Date 2024/8/7 22:50
 */
@Data
public class DynamicHeadExportDto implements Serializable {

    @ApiModelProperty("导出文件名")
    private String outputFileName;

    /**
     * k-sheet名称，v-导出配置vo
     */
    @ApiModelProperty("导出数据")
    private Map<String, DynamicHeadExportConfigVo> map;

    /**
     * k-数据字典类型，ik-数据字典编码，iv-数据字典值
     */
    @ApiModelProperty("数据字典")
    private Map<String, Map<String, String>> dictMap;
}
