/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.algorithm.db.dto;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CommonSequenceCache {
    private int maxSequenceValue;
    private int size = 0;
    private final AtomicInteger sequence;

    public CommonSequenceCache(int maxSequenceValue, int size) {
        this.sequence = new AtomicInteger(maxSequenceValue - size);
        this.maxSequenceValue = maxSequenceValue;
        this.size = size;
    }

    public Integer nextval() {
        int val = this.sequence.incrementAndGet();
        if (val > this.maxSequenceValue) {
            return null;
        }
        return val;
    }

    public String nextHexString() {
        Integer nextval = this.nextval();
        if (nextval == null) {
            return null;
        }
        return String.format("%010x", nextval);
    }

    public String nextDecString() {
        Integer nextval = this.nextval();
        if (nextval == null) {
            return null;
        }
        return String.format("%011d", nextval);
    }

    private Integer currval() {
        int val = this.sequence.get();
        if (val > this.maxSequenceValue) {
            return this.maxSequenceValue;
        }
        return val;
    }

    public List<Integer> getSeqList() {
        Integer row;
        LinkedList<Integer> list = new LinkedList<Integer>();
        while ((row = this.nextval()) != null) {
            list.add(row);
        }
        return list;
    }

    public List<String> getSeqHexList() {
        String row;
        LinkedList<String> list = new LinkedList<String>();
        while ((row = this.nextHexString()) != null) {
            list.add(row);
        }
        return list;
    }

    public List<String> getSeqDecList() {
        String row;
        LinkedList<String> list = new LinkedList<String>();
        while ((row = this.nextDecString()) != null) {
            list.add(row);
        }
        return list;
    }

    public String toString() {
        return "CommonSequenceCache(maxSequenceValue=" + this.maxSequenceValue + ", size=" + this.size + ", sequence=" + this.sequence + ")";
    }
}

