package com.biz.crm.common.sequese.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sequese.local.service.SerialNumberService;
import com.biz.crm.common.sequese.sdk.dto.SerialNumberDto;
import com.biz.crm.common.sequese.sdk.vo.SerialNumberVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

/**
 * @author XXLsansui
 * @date 2023-04-26 17:28
 * @description：序列号
 */
@Slf4j
@RestController
@RequestMapping("/v1/sequese/serial")
@Api(tags = "序列号 : SerialNumber ")
public class SerialNumberController {

  @Autowired(required = false)
  private SerialNumberService serialNumberService;


  /**
   * 查询分页列表
   *
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<SerialNumberVo>> findByConditions(@PageableDefault(50) Pageable pageable, SerialNumberDto dto) {
    try {
      dto = Optional.ofNullable(dto).orElse(new SerialNumberDto());
      Page<SerialNumberVo> result = this.serialNumberService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 针对模块添加刷新标识
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "针对模块添加刷新标识")
  @PostMapping("/addUpdateFlag")
  public Result<?> addUpdateFlag(@RequestBody SerialNumberDto dto) {
    try {
      this.serialNumberService.addUpdateFlag(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
