package com.biz.crm.common.sequese.local.algorithm.db.dto;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.ToString;

@ToString
public class CommonSequenceCache {
  /** 本组序列最大个数 */
  private int maxSequenceValue;
  /** 本组key的容量 */
  private int size = 0;
  /** 序列值 */
  private final AtomicInteger sequence;

  /**
   * @param maxSequenceValue 最大序列值
   * @param size 序列个数
   */
  public CommonSequenceCache(int maxSequenceValue, int size) {
    sequence = new AtomicInteger(maxSequenceValue - size);
    this.maxSequenceValue = maxSequenceValue;
    this.size = size;
  }

  /**
   * 获取下一个序列值
   * 
   * @return
   */
  public Integer nextval() {
    int val = sequence.incrementAndGet();
    if (val > maxSequenceValue) {
      return null;
    } else {
      return val;
    }
  }

  /**
   * 返回16进制的字符串，不足10位补0
   * 
   * @return
   */
  public String nextHexString() {
    Integer nextval = this.nextval();
    if (nextval == null) {
      return null;
    } else {
      return String.format("%010x", nextval);
    }
  }

  /**
   * 返回16进制的字符串，不足11位补0
   * 
   * @return
   */
  public String nextDecString() {
    Integer nextval = this.nextval();
    if (nextval == null) {
      return null;
    } else {
      return String.format("%011d", nextval);
    }
  }

  private Integer currval() {
    int val = sequence.get();
    if (val > maxSequenceValue) {
      return maxSequenceValue;
    } else {
      return val;
    }
  }

  /**
   * 获取List对象只能获取一次
   * 
   * @return
   */
  public List<Integer> getSeqList() {
    List<Integer> list = new LinkedList<>();
    for (Integer row; (row = this.nextval()) != null;) {
      list.add(row);
    }
    return list;
  }

  /**
   * 获取List对象只能获取一次
   * 
   * @return
   */
  public List<String> getSeqHexList() {
    List<String> list = new LinkedList<>();
    for (String row; (row = this.nextHexString()) != null;) {
      list.add(row);
    }
    return list;
  }



  /**
   * 获取List对象只能获取一次
   * 
   * @return
   */
  public List<String> getSeqDecList() {
    List<String> list = new LinkedList<>();
    for (String row; (row = this.nextDecString()) != null;) {
      list.add(row);
    }
    return list;
  }
}
