package com.biz.crm.common.sequese.local.algorithm.redis.service;

import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;
import com.biz.crm.common.sequese.sdk.generator.constant.SequeseConstant;
import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorByRedis;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * 使用 Redis 的自增原子性来生成唯一 id <br/>
 * 返回数值,逻辑参考DefaultGenerateCodeServiceImpl算法，该算法速度快，但是和数据库依赖
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023-5-8 10:20:57
 */
@Slf4j
@Component
public class CrmSequeseGeneratorByRedisImpl implements CrmSequeseGeneratorByRedis {
  /**
   * code生成规则[seq:code:default:CRM-MDM:BIZ_SEQ]
   */
  private final static String KEY_FORMAT = SequeseConstant.REDIS_SEQ_PRE + "code:%s";
  @Autowired
  private RedisTemplate redisTemplate;

  @Override
  public void initAlgorithm() {
    // 暂无
  }

  /**
   * 获取下一个值
   */
  @Override
  public Long nextVal(String subSystem, String bizCode) {
    String redisCounter = getRedisCounter(subSystem, bizCode);
    long andIncrement = this.addAndGet(redisCounter, 1);
    return andIncrement;
  }

  @Override
  public Long[] nextValArray(String subSystem, String bizCode, int seqNum) {
    // 数据纠正
    if (seqNum < 1) {
      seqNum = 1;
    }
    String redisCounter = getRedisCounter(subSystem, bizCode);
    long lastSeqVal = this.addAndGet(redisCounter, seqNum);

    // 批量赋值
    Long[] batchNextVal = new Long[seqNum];
    lastSeqVal++;
    for (int idx = 0; idx < batchNextVal.length; idx++) {
      batchNextVal[idx] = lastSeqVal - seqNum + idx;
    }
    return batchNextVal;
  }

  @Override
  public Long currVal(String subSystem, String bizCode) {
    String redisCounter = getRedisCounter(subSystem, bizCode);
    Long currVal = (Long) redisTemplate.opsForValue().get(redisCounter);
    return currVal;
  }

  /**
   * 返回主键
   */
  @Override
  public String getKey(String subSystem, String bizCode) {
    String key = String.format("%s:%s:%s", TenantUtils.getTenantCode(), subSystem.toUpperCase(), bizCode);
    return key;
  }

  // /**
  // * 返回主键过期时间，给项目组扩展<br/>
  // * 如果返回null，则为不限制
  // */
  // public Date getKeyExpireAtDate() {
  // return null;
  // }

  /**
   * 当前算法规则
   * 
   * @return
   */
  @Override
  public String getSequeseRuleCode() {
    return "REDIS算法";
  }

  private String getRedisCounter(String subSystem, String bizCode) {
    String key = this.getKey(subSystem, bizCode);
    String redisCounter = String.format(KEY_FORMAT, key);
    return redisCounter;
  }

  /**
   * 基于redis进行key上值的递增
   * 
   * @param redisCounter key的完整路径
   * @param stepNum
   * @return
   */
  private Long addAndGet(String redisCounter, int stepNum) {
    RedisAtomicLong entityIdCounter = new RedisAtomicLong(redisCounter, redisTemplate);
    long addAndGet = entityIdCounter.addAndGet(stepNum);
    if (addAndGet == 1) {
      // 将该对象过期时间进行设置
      Date date = getKeyExpireAtDate();
      if (date != null) {// 获取是否配置过期时间，如果设置则进行过期时间配置
        entityIdCounter.expireAt(date);
      }
    }
    return addAndGet;
  }


}
