package com.biz.crm.common.sequese.local.algorithm.db.mapper;

import org.apache.ibatis.annotations.Mapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.common.sequese.local.algorithm.db.dto.CommonSequenceNextvalDto;
import com.biz.crm.common.sequese.local.algorithm.db.entity.CommonSequenceEntity;

/**
 * 通用序列号生成;(sfa_common_sequence)表数据库访问层
 * 
 * @author : Ken.xu
 * @date : 2023-3-29
 */
@Mapper
public interface CommonSequenceMapper extends BaseMapper<CommonSequenceEntity> {
  // selectkey时 Dao接口请勿使用@Param 映射注解
  /**
   * 获取当前序列号
   *
   * @param seqName 主键
   * @return 序列值
   */
  Integer currval(String tenantCode, String seqName);

  /**
   * 获取下一个序列号
   *
   * @param seqName 序列名称
   * @return 序列值
   */
  Integer nextval(CommonSequenceNextvalDto dto);


}
