/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.algorithm.db.service;

import com.biz.crm.common.sequese.local.algorithm.db.dto.CommonSequenceNextvalDto;
import com.biz.crm.common.sequese.local.algorithm.db.entity.CommonSequenceEntity;
import com.biz.crm.common.sequese.local.algorithm.db.mapper.CommonSequenceMapper;
import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorByDb;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CrmSequeseGeneratorByDbImpl
implements CrmSequeseGeneratorByDb {
    private static final Logger log = LoggerFactory.getLogger(CrmSequeseGeneratorByDbImpl.class);
    @Autowired
    private CommonSequenceMapper commonSequenceMapper;
    private final Lock lock = new ReentrantLock();

    public void initAlgorithm() {
        log.info("\u521d\u59cb\u5316\u4effOracle\u5e8f\u5217\u53f7\u751f\u6210\u5668");
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Integer nextVal(String subSystem, String bizCode) {
        String key = this.getKey(subSystem, bizCode);
        return this.nextvalExe(key, 1);
    }

    public Integer[] nextValArray(String subSystem, String bizCode, int seqNum) {
        if (seqNum < 1) {
            seqNum = 1;
        }
        String key = this.getKey(subSystem, bizCode);
        Integer lastSeqVal = this.nextvalExe(key, seqNum);
        Integer[] batchNextVal = new Integer[seqNum];
        Integer n = lastSeqVal;
        Integer n2 = lastSeqVal = Integer.valueOf(lastSeqVal + 1);
        for (int idx = 0; idx < batchNextVal.length; ++idx) {
            batchNextVal[idx] = lastSeqVal - seqNum + idx;
        }
        return batchNextVal;
    }

    public Integer currVal(String subSystem, String bizCode) {
        String key = this.getKey(subSystem, bizCode);
        return this.currvalExe(key);
    }

    public String getKey(String subSystem, String bizCode) {
        return String.format("%s:%s", subSystem, bizCode);
    }

    public String getSequeseRuleCode() {
        return "\u6570\u636e\u5e93\u7b97\u6cd5";
    }

    private Integer currvalExe(String seqName) {
        String tenantCode = TenantUtils.getTenantCode();
        Integer val = this.commonSequenceMapper.currval(tenantCode, seqName);
        if (val == null) {
            this.createSeq(tenantCode, seqName);
        }
        val = this.commonSequenceMapper.currval(tenantCode, seqName);
        return val;
    }

    private Integer nextvalExe(String seqName, int incrementBy) {
        Integer affectRow;
        String tenantCode = TenantUtils.getTenantCode();
        CommonSequenceNextvalDto dto = new CommonSequenceNextvalDto();
        dto.setSeqName(seqName);
        dto.setTenantCode(tenantCode);
        dto.setIncrementBy(incrementBy);
        try {
            affectRow = this.commonSequenceMapper.nextval(dto);
        }
        catch (MyBatisSystemException mse) {
            String message = mse.getMessage();
            if (message.contains("SelectKey returned no data.")) {
                affectRow = 0;
            }
            throw mse;
        }
        if (affectRow == 0) {
            this.createSeq(tenantCode, seqName);
            this.commonSequenceMapper.nextval(dto);
        }
        return dto.getSeqValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSeq(String tenantCode, String seqName) {
        CommonSequenceNextvalDto dto = new CommonSequenceNextvalDto();
        dto.setSeqName(seqName);
        dto.setTenantCode(tenantCode);
        boolean createOk = false;
        this.lock.lock();
        try {
            Integer currval = this.commonSequenceMapper.currval(tenantCode, seqName);
            if (currval != null) {
                createOk = true;
            } else {
                CommonSequenceEntity entity = new CommonSequenceEntity();
                entity.setTenantCode(tenantCode);
                entity.setSeqName(seqName);
                int insert = this.commonSequenceMapper.insert((Object)entity);
                if (insert != 0) {
                    createOk = true;
                }
            }
        }
        catch (DuplicateKeyException e) {
            createOk = true;
        }
        finally {
            this.lock.unlock();
        }
        return createOk;
    }
}

