/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.algorithm.redis.service;

import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorByRedis;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
public class CrmSequeseGeneratorByRedisImpl
implements CrmSequeseGeneratorByRedis {
    private static final Logger log = LoggerFactory.getLogger(CrmSequeseGeneratorByRedisImpl.class);
    private static final String KEY_FORMAT = "seq:code:%s";
    @Autowired
    private RedisTemplate redisTemplate;

    public void initAlgorithm() {
    }

    public Long nextVal(String subSystem, String bizCode) {
        String redisCounter = this.getRedisCounter(subSystem, bizCode);
        long andIncrement = this.addAndGet(redisCounter, 1);
        return andIncrement;
    }

    public Long[] nextValArray(String subSystem, String bizCode, int seqNum) {
        if (seqNum < 1) {
            seqNum = 1;
        }
        String redisCounter = this.getRedisCounter(subSystem, bizCode);
        long lastSeqVal = this.addAndGet(redisCounter, seqNum);
        Long[] batchNextVal = new Long[seqNum];
        ++lastSeqVal;
        for (int idx = 0; idx < batchNextVal.length; ++idx) {
            batchNextVal[idx] = lastSeqVal - (long)seqNum + (long)idx;
        }
        return batchNextVal;
    }

    public Long currVal(String subSystem, String bizCode) {
        String redisCounter = this.getRedisCounter(subSystem, bizCode);
        Long currVal = (Long)this.redisTemplate.opsForValue().get((Object)redisCounter);
        return currVal;
    }

    public String getKey(String subSystem, String bizCode) {
        String key = String.format("%s:%s:%s", TenantUtils.getTenantCode(), subSystem.toUpperCase(), bizCode);
        return key;
    }

    public String getSequeseRuleCode() {
        return "REDIS\u7b97\u6cd5";
    }

    private String getRedisCounter(String subSystem, String bizCode) {
        String key = this.getKey(subSystem, bizCode);
        String redisCounter = String.format(KEY_FORMAT, key);
        return redisCounter;
    }

    private Long addAndGet(String redisCounter, int stepNum) {
        Date date;
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(redisCounter, (RedisOperations)this.redisTemplate);
        long addAndGet = entityIdCounter.addAndGet((long)stepNum);
        if (addAndGet == 1L && (date = this.getKeyExpireAtDate()) != null) {
            entityIdCounter.expireAt(date);
        }
        return addAndGet;
    }
}

