/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.sequese.local.service.SerialNumberService;
import com.biz.crm.common.sequese.sdk.dto.SerialNumberDto;
import com.biz.crm.common.sequese.sdk.vo.SerialNumberVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sequese/serial"})
@Api(tags={"\u5e8f\u5217\u53f7 : SerialNumber "})
public class SerialNumberController {
    private static final Logger log = LoggerFactory.getLogger(SerialNumberController.class);
    @Autowired(required=false)
    private SerialNumberService serialNumberService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<SerialNumberVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, SerialNumberDto dto) {
        try {
            dto = Optional.ofNullable(dto).orElse(new SerialNumberDto());
            Page<SerialNumberVo> result = this.serialNumberService.findByConditions(pageable, dto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9488\u5bf9\u6a21\u5757\u6dfb\u52a0\u5237\u65b0\u6807\u8bc6")
    @PostMapping(value={"/addUpdateFlag"})
    public Result<?> addUpdateFlag(@RequestBody SerialNumberDto dto) {
        try {
            this.serialNumberService.addUpdateFlag(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

