package com.biz.crm.common.sequese.local.service.noparam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import com.biz.crm.common.sequese.local.config.CommonSequeseConfig;
import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorBySnowFlake;
import com.biz.crm.common.sequese.sdk.generator.service.base.CrmBizSequenceServiceByNoParam;
import lombok.Getter;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;

/**
 * 系统默认序列化服务，不接收任何参数（雪花算法，10进制）
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023年4月24日 上午10:18:42
 * @param <K>
 */
@ToString
@Slf4j
@Component /* 全局唯一，必须设定组件名称 */
@Order(1)
public class CrmBizSequenceServiceByNoParamImpl
    implements CrmBizSequenceServiceByNoParam<CrmSequeseGeneratorBySnowFlake> {

  @Override
  public String getSeqInfoByBizCode() {
    return "MDM_SEQ_NO_PARAM_SNOWFLAKE";
  }

  @Override
  public String getSeqInfoByColumnDesc() {
    return "SnowFlake无参";
  }

  @Override
  public String getSeqInfoByModleName() {
    return "雪花算法，无参 系统默认";
  }

  /** 获取日志对象 */
  public org.slf4j.Logger getLogger() {
    return this.log;
  }

  /** 将要使用的序列算法通过Spring注入进来 */
  @Getter
  @Autowired
  CrmSequeseGeneratorBySnowFlake generator;

  @Override
  public String getSubSystem() {
    return CommonSequeseConfig.subsystem;
  }

  @Override
  public String generatorFormat(Long sequese) {
    return sequese + "";
  }
}


