package com.biz.crm.common.sequese.local.config;

import com.biz.crm.common.sequese.sdk.generator.constant.SequeseConstant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Configuration;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.text.CharSequenceUtil;

/**
 * sequese模块配置
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023年4月21日 下午6:40:24
 */
@Configuration
@EntityScan(basePackages = "com.biz.crm.common.sequese.local.**.entity")
public class CommonSequeseConfig {
  /** 每次查询redis标示，1秒内不再重复请求redis查询 */
  public static final TimedCache<String, Boolean> lastLoadRedisCache = new TimedCache<>(1000);
  /** 每次保存redis后，1秒钟内不再推redis */
  public static final TimedCache<String, Boolean> saveLashSeqCache = new TimedCache<>(1000);
  /** 子系统名字，例如：CRM-MDM，注意，该属性禁止在static类上赋值使用 */
  public static String subsystem;
  /** redis中要保存所有，注意，该属性禁止在static类上赋值使用 */
  public static String SAVE_ALL_KEY;

  @Value("${spring.application.name:}")
  public void setSubsystem(String subsystem) {
    CommonSequeseConfig.subsystem = subsystem;
    CommonSequeseConfig.SAVE_ALL_KEY = CharSequenceUtil.format(SequeseConstant.SEQ_CACHE_SAVE_ALL, CommonSequeseConfig.subsystem);
  }
}
