package com.biz.crm.common.sequese.local.algorithm.db.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 通用序列号生成
 * 
 * @author : Ken.xu
 * @date : 2023-3-30
 */
@ApiModel(value = "通用序列号生成", description = "")
@TableName("common_sequence")
@Getter
@Setter
@ToString(callSuper = false)
@Entity
@Table(name = "common_sequence", indexes = {
    @Index(name = "idx_seq_name", unique = true, columnList = "tenant_code, seq_name"),
})
@org.hibernate.annotations.Table(appliesTo = "common_sequence", comment = "通用序列号生成")
public class CommonSequenceEntity extends UuidEntity {
  private static final long serialVersionUID = 1L;
  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  @TableField(value = "tenant_code")
  @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT '租户编号'")
  private String tenantCode;

  /** seq名称 */
  @ApiModelProperty(name = "seqName", value = "seq名称")
  @Column(name = "seq_name", nullable = false, length = 200, columnDefinition = "varchar(200) COMMENT 'seq名称'")
  private String seqName;

  /** seq值 */
  @ApiModelProperty(name = "seqValue", value = "seq值")
  @Column(name = "seq_value", columnDefinition = "int COMMENT 'seq值' default 0")
  private Integer seqValue;

}
