package com.biz.crm.common.sequese.sdk.generator.service;

import com.biz.crm.common.sequese.sdk.generator.service.base.CrmBizSequenceServiceByStrategy;

/**
 * 扩展点1：编码规则接口【扩展点1，实现指定接口，用于返回指定（模块、业务编码）下的全局唯一的值】， 使用的类，必须扩展Component注解和Description注解
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023年4月21日 下午6:49:49
 * @param <K> Dto对象类型
 * @param <T> CrmSequeseGenerator 实现类
 * @param <V> 序列
 * @see CrmBizSequenceServiceByInteger
 * @see CrmBizSequenceServiceByString
 */
public interface CrmBizSequenceServiceByLong<K, T extends CrmSequeseGenerator<Long>>
    extends CrmBizSequenceServiceByStrategy<K, T, Long> {
  @Override
  default Long getSequese(String subSystem, String bizCode) {
    return CrmBizSequenceServiceByStrategy.super.getSequese(subSystem, bizCode);
  }

  @Override
  default Long[] getSequeseArray(String subsystem, String bizCode, int seqNum) {
    return CrmBizSequenceServiceByStrategy.super.getSequeseArray(subsystem, bizCode, seqNum);
  }
}
