package com.biz.crm.common.sequese.sdk.generator.service;

/**
 * 扩展点2：平台算法接口【扩展点2，用于系统扫描，在后台进行展示序列值使用】
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023年4月21日 下午6:49:39
 */
public interface CrmSequeseGenerator<T> {
  /** Spring加载对象后，算法进行自我初始化 */
  void initAlgorithm();

  /**
   * 根据业务系统编码、业务编码 返回的code要algorithm类内部根据【subSystem（crm-dms、crm-mdm）, bizCode（order，）】作为主键，全系统唯一
   */
  T nextVal(String subSystem, String bizCode);

  /**
   * 根据业务系统编码、业务编码 返回的code要algorithm类内部根据【subSystem（crm-dms、crm-mdm）, bizCode（order，）】作为主键，全系统唯一
   */
  T currVal(String subSystem, String bizCode);

  /**
   * 获取一组序列值
   * 
   * @param subSystem 业务系统编码
   * @param bizCode 业务编码
   * @param seqNum 批量返回的个数
   * @return 返回的code要algorithm类内部根据【subSystem（crm-dms、crm-mdm）, bizCode（order，）】作为主键，全系统唯一
   */
  T[] nextValArray(String subSystem, String bizCode, int seqNum);

  /**
   * 返回子系统+业务编码的key（可以用于redis或其他Pk的系统）
   * 
   * @param subSystem
   * @param bizCode
   * @return
   */
  String getKey(String subSystem, String bizCode);

  /**
   * 当前算法名称
   * 示例: REDIS算法
   * @return
   */
  String getSequeseRuleCode();

}
