package com.biz.crm.common.form.local.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.module.ModuleRegister;

import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@RestController
@RequestMapping(value = {"/v1/dynamicform/modules"})
public class ModuleRegisterController {
  @Order
  @Autowired(required = false)
  private List<ModuleRegister> moduleRegisters;
  
  @ApiOperation(value = "查询目前系统中已经注册的基于动态表单模块工作的业务分组（已测试）")
  @GetMapping(value = "findAll")
  public Result findAll() {
    try {
      JSONArray results = new JSONArray();
      for (ModuleRegister moduleRegister : moduleRegisters) {
        String moduleCode = moduleRegister.moduleCode();
        String moduleName = moduleRegister.moduleName();
        
        JSONObject result = new JSONObject();
        result.put("moduleCode", moduleCode);
        result.put("moduleName", moduleName);
        results.add(result);
      }
      return Result.ok(results);
    } catch(RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
