package com.biz.crm.common.form.local.controller;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;

import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

/**
 * 动态表单模块中提供给前端的和操作策略情况查询有关的http接口
 * @author yinwenjie
 */
@Slf4j
@RestController
@RequestMapping(value = {"/v1/dynamicform/operation"})
public class OperationStrategyController {
  @Order
  @Autowired(required = false)
  private List<OperationStrategy<? extends DynamicForm>> operationStrateis;
  
  @ApiOperation(value = "动态表单")
  @GetMapping(value = "findByDynamicFormCodeAndModuleCode")
  public Result findByDynamicFormCodeAndModuleCode(@RequestParam("dynamicFormCode") String dynamicFormCode ,
                                                      @RequestParam("moduleCode")  String moduleCode) {
    try {
      JSONObject result = new JSONObject();
      for (OperationStrategy<? extends DynamicForm> operationStrategy : operationStrateis) {
        String dynamicFormCodeItem = operationStrategy.dynamicFormCode();
        String dynamicFormNameItem = operationStrategy.dynamicFormName();
        String moduleCodeItem = operationStrategy.moduleCode();
        if(!StringUtils.equals(dynamicFormCode, dynamicFormCodeItem) || !StringUtils.equals(moduleCode, moduleCodeItem)) {
          continue;
        }
        
        result.put("dynamicFormCode", dynamicFormCodeItem);
        result.put("dynamicFormName", dynamicFormNameItem);
        result.put("moduleCode", moduleCodeItem);
        break;
      }
      return Result.ok(result);
    } catch(RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  @ApiOperation(value = "按照业务分组，查询该业务分组下已注册的动态表单操作策略（已测试）")
  @GetMapping(value = "findByModuleCode")
  public Result findByModuleCode(@RequestParam("moduleCode")  String moduleCode) {
    try {
      JSONArray results = new JSONArray();
      for (OperationStrategy<? extends DynamicForm> operationStrategy : operationStrateis) {
        String dynamicFormCodeItem = operationStrategy.dynamicFormCode();
        String dynamicFormNameItem = operationStrategy.dynamicFormName();
        String moduleCodeItem = operationStrategy.moduleCode();
        if(!StringUtils.equals(moduleCode, moduleCodeItem)) {
          continue;
        }
        
        JSONObject result = new JSONObject();
        result.put("dynamicFormCode", dynamicFormCodeItem);
        result.put("dynamicFormName", dynamicFormNameItem);
        result.put("moduleCode", moduleCodeItem);
        results.add(result);
      }
      return Result.ok(results);
    } catch(RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
