package com.biz.crm.common.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 记录动态表单的字段映射关系
 *
 * @author yinwenjie
 */
@Getter
@Setter
@Entity
@TableName("engine_dynamic_form_field")
@Table(name = "engine_dynamic_form_field", indexes = {
        @Index(name = "engine_d_form_field_uq1", columnList = "dynamic_form_code,mapping_code,field_code", unique = true),
        @Index(name = "engine_d_form_field_idx1", columnList = "group_index,sort_index", unique = false),
})
@ApiModel(value = "DynamicFormFieldMapping", description = "系统消息")
@org.hibernate.annotations.Table(appliesTo = "engine_dynamic_form_field", comment = "系统消息")
public class DynamicFormFieldMapping extends UuidEntity {
    private static final long serialVersionUID = 8710574424125315345L;

    /**
     * 映射动态表单字段的业务编号（例如活动细类编号、电脑模板编号等等）
     */
    @ApiModelProperty(name = "mappingCode", value = "映射动态表单字段的业务编号", required = false)
    @Column(name = "mapping_code", nullable = true, columnDefinition = "VARCHAR2(255)")
    private String mappingCode;
    /**
     * 用于处理该动态表单结构的操作处理策略业务编码（全系统唯一）
     */
    @ApiModelProperty(name = "dynamicFormCode", value = "用于处理该动态表单结构的操作处理策略业务编码（全系统唯一）", required = false)
    @Column(name = "dynamic_form_code", nullable = true, columnDefinition = "VARCHAR2(255)")
    private String dynamicFormCode;
    /**
     * 字段名,从202211版本开始，字段支持多级，多级字段以如下方式命名：
     * field1.field2
     */
    @ApiModelProperty(name = "fieldCode", value = "字段名", required = false)
    @Column(name = "field_code", nullable = false, columnDefinition = "VARCHAR2(255)")
    private String fieldCode;
    /**
     * 字段名称
     */
    @ApiModelProperty(name = "fieldName", value = "字段名称", required = false)
    @Column(name = "field_name", nullable = true, columnDefinition = "VARCHAR2(255)")
    private String fieldName;
    /**
     * 该字段是否为非必填：true非必填；false：必填
     */
    @ApiModelProperty(name = "nullable", value = "该字段是否为非必填：true非必填；false：必填", required = false)
    @Column(name = "nullable", nullable = false, columnDefinition = "VARCHAR2(2)")
    private Boolean nullable;
    /**
     * 字段映射信息的排序号，越小，排在越前面
     */
    @ApiModelProperty(name = "sortIndex", value = "字段映射信息的排序号，越小，排在越前面", required = false)
    @Column(name = "sort_index", nullable = true, columnDefinition = "INT")
    private Integer sortIndex;
    /**
     * 分组信息
     */
    @ApiModelProperty(name = "groupIndex", value = "分组信息", required = false)
    @Column(name = "group_index", nullable = true, columnDefinition = "VARCHAR2(128)")
    private String groupIndex;
}
