/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.widget.WidgetKey;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dynamicform/widgets"})
public class WidgetController {
    private static final Logger log = LoggerFactory.getLogger(WidgetController.class);
    @Autowired
    private Set<WidgetKey> widgets;

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\u6240\u6709\u7684\u63a7\u4ef6")
    @GetMapping(value={"/findAll"})
    public Result<?> findAll() {
        try {
            JSONArray jsonArray = new JSONArray();
            for (WidgetKey widget : this.widgets) {
                String widgetCode = widget.widgetCode();
                String widgetName = widget.widgetName();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("widgetCode", (Object)widgetCode);
                jsonObject.put("widgetName", (Object)widgetName);
                jsonArray.add((Object)jsonObject);
            }
            return Result.ok((Object)jsonArray);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

