package com.biz.crm.common.form.local.service.op;

import java.lang.reflect.Field;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import com.biz.crm.common.form.sdk.field.ValidateStrategy;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.model.DynamicForm;

/**
 * 该抽象类，主要存储了一些公共的方法，以便减少具体的操作策略实现类中的代码冗余度
 * @author yinwenjie
 */
public abstract class AbstractDynamicFormServiceOpStrategy {
  private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDynamicFormServiceOpStrategy.class);
  
  @Autowired
  private ApplicationContext applicationContext;
  
  protected void fieldValidate(Field declaredField , DynamicForm dynamicFormObject , Object mainForm) {
    DynamicField dynamicFieldAnnotation = declaredField.getAnnotation(DynamicField.class);
    if(dynamicFieldAnnotation == null) {
      return;
    }
    com.biz.crm.common.form.sdk.field.annotation.Validate validateAnnotations[] = dynamicFieldAnnotation.validates();
    if(validateAnnotations == null || validateAnnotations.length == 0) {
      return;
    }
    // 获得相关字段的值
    Object declaredFieldValue = null;
    try {
      declaredFieldValue = declaredField.get(dynamicFormObject);
    } catch (IllegalArgumentException | IllegalAccessException e) {
      LOGGER.error(e.getMessage() , e);
      return;
    }
    String declaredFieldName = declaredField.getName();
    
    // 如果代码走到这里，说明当前字段存在转换验证要求
    for (com.biz.crm.common.form.sdk.field.annotation.Validate validate : validateAnnotations) {
      Class<? extends ValidateStrategy> validateStrategyClass = validate.value();
      if(validateStrategyClass == null) {
        continue;
      }
      ValidateStrategy validateStrategy = null;
      Object[] inputs = validate.inputs();
      // 开始验证
      if(inputs == null || inputs.length == 0) {
        validateStrategy = applicationContext.getBean(validateStrategyClass); 
      } else {
        validateStrategy = (ValidateStrategy)applicationContext.getBean(validateStrategyClass, inputs);
      }
      validateStrategy.validate(declaredFieldValue, declaredFieldName, declaredField, mainForm);
    }
  }
}
