/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.service.internal;

import com.biz.crm.common.form.local.utils.DynamicFormUtils;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategyService;
import com.biz.crm.common.form.sdk.vo.DynamicFormVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OperationStrategyServiceImpl
implements OperationStrategyService {
    @Autowired(required=false)
    private List<OperationStrategy<? extends DynamicForm>> operationStraties;
    @Autowired
    private ApplicationContext applicationContext;

    public DynamicFormVo findByDynamicFormCode(String dynamicFormCode) {
        if (StringUtils.isBlank((CharSequence)dynamicFormCode) || CollectionUtils.isEmpty(this.operationStraties)) {
            return null;
        }
        OperationStrategy<? extends DynamicForm> selectedOperationStrategy = null;
        for (OperationStrategy<? extends DynamicForm> operationStrategy : this.operationStraties) {
            if (!StringUtils.equals((CharSequence)operationStrategy.dynamicFormCode(), (CharSequence)dynamicFormCode)) continue;
            selectedOperationStrategy = operationStrategy;
        }
        if (selectedOperationStrategy == null) {
            return null;
        }
        Class dynamicFormClass = selectedOperationStrategy.dynamicFormClass();
        DynamicFormVo dynamicFormVo = DynamicFormUtils.analysis(dynamicFormClass, this.applicationContext);
        dynamicFormVo.setDynamicFormCode(dynamicFormCode);
        return dynamicFormVo;
    }
}

