/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.service.op;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.local.service.DynamicFormServiceOpStrategy;
import com.biz.crm.common.form.local.service.op.AbstractDynamicFormServiceOpStrategy;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SingleDynamicFormServiceOpStrategy
extends AbstractDynamicFormServiceOpStrategy
implements DynamicFormServiceOpStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleDynamicFormServiceOpStrategy.class);

    @Override
    public int sort() {
        return 0;
    }

    @Override
    public boolean support(boolean isValueCollection, Class<?> collectionClass) {
        return !isValueCollection;
    }

    @Override
    public <T> Map<String, T> createMapbeforeOp() {
        LinkedHashMap targetMapValue = Maps.newLinkedHashMap();
        return targetMapValue;
    }

    @Override
    public <T> void convert(Map<String, T> targetMapValueSet, Object mainForm, Field dynamicField, String dynamicKey, JSON jsonValue, Class<? extends DynamicForm> targetDynamicFormClass, boolean isValueCollection, Class<?> collectionClass) {
        String dynamicFieldCode = dynamicField.getName();
        if (isValueCollection || !(jsonValue instanceof JSONObject)) {
            LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u8f6c\u6362\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u7684\u7c7b\u578b\u548cjson\u7ed3\u6784\u7684\u503c\u4e0d\u80fd\u5bf9\u5e94\uff08json\u4e3a\u6570\u7ec4\uff09\uff0c\u8bf7\u68c0\u67e5!!");
            return;
        }
        DynamicForm dynamicFormObject = (DynamicForm)JSON.parseObject((String)jsonValue.toJSONString(), targetDynamicFormClass);
        if (dynamicFormObject != null) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = targetDynamicFormClass.getDeclaredFields()) {
                declaredField.setAccessible(true);
                this.fieldValidate(declaredField, dynamicFormObject, mainForm);
            }
        }
        targetMapValueSet.put(dynamicKey, dynamicFormObject);
    }

    @Override
    public void createOp(OperationStrategy<? extends DynamicForm> operationStrategy, String dynamicKey, Object dynamicKeyObject, Object formObject, String parentCode) {
        Validate.isTrue((boolean)DynamicFormOperationStrategy.class.isAssignableFrom(operationStrategy.getClass()), (String)"\u4e0d\u6b63\u786e\u7684\u52a8\u6001\u8868\u5355(\u521b\u5efa)\u64cd\u4f5c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DynamicFormOperationStrategy dynamicFormOperationStrategy = (DynamicFormOperationStrategy)operationStrategy;
        DynamicForm dynamicForm = (DynamicForm)dynamicKeyObject;
        dynamicFormOperationStrategy.onDynamicFormCreate(dynamicForm, dynamicKey, parentCode, formObject);
    }

    @Override
    public void modifyOp(OperationStrategy<? extends DynamicForm> operationStrategy, String dynamicKey, Object dynamicKeyObject, Object formObject, String parentCode) {
        Validate.isTrue((boolean)DynamicFormOperationStrategy.class.isAssignableFrom(operationStrategy.getClass()), (String)"\u4e0d\u6b63\u786e\u7684\u52a8\u6001\u8868\u5355(\u4fee\u6539)\u64cd\u4f5c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DynamicFormOperationStrategy dynamicFormOperationStrategy = (DynamicFormOperationStrategy)operationStrategy;
        DynamicForm dynamicForm = (DynamicForm)dynamicKeyObject;
        dynamicFormOperationStrategy.onDynamicFormModify(dynamicForm, dynamicKey, parentCode, formObject);
    }

    @Override
    public Object findByParentCode(OperationStrategy<? extends DynamicForm> operationStrategy, String dynamicKey, String parentCode) {
        Validate.isTrue((boolean)DynamicFormOperationStrategy.class.isAssignableFrom(operationStrategy.getClass()), (String)"\u4e0d\u6b63\u786e\u7684\u52a8\u6001\u8868\u5355(\u67e5\u8be2/\u5b8c\u5584)\u64cd\u4f5c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DynamicFormOperationStrategy dynamicFormOperationStrategy = (DynamicFormOperationStrategy)operationStrategy;
        DynamicForm result = dynamicFormOperationStrategy.findByParentCode(dynamicKey, parentCode);
        return result;
    }

    @Override
    public void findAndMergeByParentCode(OperationStrategy<? extends DynamicForm> operationStrategy, String dynamicKey, Field dynamicField, Object formObject, String parentCode) {
        DynamicForm result = (DynamicForm)this.findByParentCode(operationStrategy, dynamicKey, parentCode);
        if (result == null) {
            return;
        }
        Map dynamicFieldValue = null;
        try {
            dynamicFieldValue = (Map)dynamicField.get(formObject);
            if (dynamicFieldValue == null) {
                dynamicFieldValue = Maps.newLinkedHashMap();
                dynamicField.set(formObject, dynamicFieldValue);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return;
        }
        dynamicFieldValue.put(dynamicKey, result);
    }
}

