package com.biz.crm.common.form.local.service.op;

import java.lang.reflect.Field;
import java.util.Map;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.local.service.DynamicFormServiceOpStrategy;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.google.common.collect.Maps;

/**
 * 该服务操作策略用于处理Map结构中，其Value部分为单个对象的情况
 * @author yinwenjie
 */
@Component
public class SingleDynamicFormServiceOpStrategy extends AbstractDynamicFormServiceOpStrategy implements DynamicFormServiceOpStrategy {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SingleDynamicFormServiceOpStrategy.class);
  
  @Override
  public int sort() {
    return 0;
  }

  @Override
  public boolean support(boolean isValueCollection, Class<?> collectionClass) {
    // 如果Map性质的字段/属性，其Value部分不是集合性质，这个操作策略就可以支持处理
    return !isValueCollection;
  }

  @Override
  public <T> Map<String , T> createMapbeforeOp() {
    Map<String , T> targetMapValue = Maps.newLinkedHashMap();
    return targetMapValue;
  } 
  
  @SuppressWarnings("unchecked")
  @Override
  public <T> void convert(Map<String , T> targetMapValueSet , Object mainForm, Field dynamicField , String dynamicKey
                          , JSON jsonValue, Class<? extends DynamicForm> targetDynamicFormClass 
                          , boolean isValueCollection, Class<?> collectionClass) {
    
    String dynamicFieldCode = dynamicField.getName();
    if(isValueCollection || !(jsonValue instanceof JSONObject)) {
      LOGGER.warn("进行动态模型数据转换时，发现“" + dynamicFieldCode + "”的类型和json结构的值不能对应（json为数组），请检查!!");
      return;
    }
    
    // 开始正式进行转换并完成赋值
    DynamicForm dynamicFormObject = JSON.parseObject(jsonValue.toJSONString(), targetDynamicFormClass);
    // 确定当前的对象信息，是符合注解上要求的验证策略的
    if(dynamicFormObject != null) {
      Field[] declaredFields = targetDynamicFormClass.getDeclaredFields();
      for (Field declaredField : declaredFields) {
        declaredField.setAccessible(true);
        this.fieldValidate(declaredField, dynamicFormObject, mainForm);
      }
    }
    
    targetMapValueSet.put(dynamicKey, (T)dynamicFormObject);
  }

  @SuppressWarnings("unchecked")
  @Override
  public void createOp(OperationStrategy<? extends DynamicForm> operationStrategy , 
                           String dynamicKey , Object dynamicKeyObject ,
                           Object formObject , String parentCode) {
    Validate.isTrue(DynamicFormOperationStrategy.class.isAssignableFrom(operationStrategy.getClass()), "不正确的动态表单(创建)操作策略，请检查!!");
    DynamicFormOperationStrategy<DynamicForm> dynamicFormOperationStrategy = (DynamicFormOperationStrategy<DynamicForm>)operationStrategy;
    DynamicForm dynamicForm = (DynamicForm)dynamicKeyObject;
    dynamicFormOperationStrategy.onDynamicFormCreate(dynamicForm, dynamicKey, parentCode, formObject);
  }

  @SuppressWarnings("unchecked")
  @Override
  public void modifyOp(OperationStrategy<? extends DynamicForm> operationStrategy,
      String dynamicKey, Object dynamicKeyObject, Object formObject, String parentCode) {
    Validate.isTrue(DynamicFormOperationStrategy.class.isAssignableFrom(operationStrategy.getClass()), "不正确的动态表单(修改)操作策略，请检查!!");
    DynamicFormOperationStrategy<DynamicForm> dynamicFormOperationStrategy = (DynamicFormOperationStrategy<DynamicForm>)operationStrategy;
    DynamicForm dynamicForm = (DynamicForm)dynamicKeyObject;
    dynamicFormOperationStrategy.onDynamicFormModify(dynamicForm, dynamicKey, parentCode, formObject);
  }
  
  @SuppressWarnings("unchecked")
  @Override
  public Object findByParentCode(OperationStrategy<? extends DynamicForm> operationStrategy, String dynamicKey, String parentCode) {
    // 使用该操作策略进行处理的，一定是主业务模型数据中，Map性质的字段其Value部分为List的情况
    Validate.isTrue(DynamicFormOperationStrategy.class.isAssignableFrom(operationStrategy.getClass()), "不正确的动态表单(查询/完善)操作策略，请检查!!");
    DynamicFormOperationStrategy<DynamicForm> dynamicFormOperationStrategy = (DynamicFormOperationStrategy<DynamicForm>)operationStrategy;
    DynamicForm result = dynamicFormOperationStrategy.findByParentCode(dynamicKey , parentCode);
    return result;
  }
  
  @SuppressWarnings("unchecked")
  @Override
  public void findAndMergeByParentCode(OperationStrategy<? extends DynamicForm> operationStrategy,
      String dynamicKey, Field dynamicField, Object formObject, String parentCode) {
    DynamicForm result = (DynamicForm)this.findByParentCode(operationStrategy, dynamicKey, parentCode);
    if(result == null) {
      return;
    }
    
    // 以K-V形式，设置到主模型上面
    Map<String , DynamicForm> dynamicFieldValue = null;
    try {
      dynamicFieldValue = (Map<String , DynamicForm>)dynamicField.get(formObject);
      if(dynamicFieldValue == null) {
        dynamicFieldValue = Maps.newLinkedHashMap();
        dynamicField.set(formObject, dynamicFieldValue);
      }
    } catch (IllegalArgumentException | IllegalAccessException e) {
      LOGGER.error(e.getMessage() , e);
      return;
    }
    
    // 一定是一个Map，且Value部分为一个独立的DynamicForm;
    dynamicFieldValue.put(dynamicKey, result);
  }
}
