package com.biz.crm.common.form.sdk;

/**
 * 该构建者用于构造在某个业务场景下的动态表单操作服务
 * @author yinwenjie
 *
 */
public interface DynamicFormServiceBuilder<T> {
  
  /**
   * 设定主模型中的一个用户定义属性（字段），为关联了动态表单结构的属性（注意，该属性/字段），一定是一个Map结构
   * @return 一旦一个属性（字段）被设定成了和动态表单结构关联的属性，那么就需要通过DynamicFieldConfiguration详细设定关联信息
   * @throws 如果没有在模型中找到这个字段名，将抛出异常信息
   */
  public <R> DynamicFieldConfiguration<T> dynamicField(String field);
  
  /**
   * 完成构建，返回具体模型的动态表单处理服务
   */
  public DynamicFormService<T> build(); 
}
