package com.biz.crm.common.form.sdk.context;

/**
 * CRM 3.0 动态表单 上下文管理器</p>
 * 
 * 目前动态表单的上下文依附于线程上下文，也就是说同一个主表单上不同动态表单的操作，如果想要同步线程上下文，则需要保证这些动态表单的处理操作，在同一个线程上；</p>
 * 
 * 注意：一定要在所有操作结束前记得清理
 * 
 * @author yinwenjie
 */
public class DynamicFormContextHolder {
  /**
   * 以线程为单位的上下文
   */
  private static final ThreadLocal<DynamicFormContext> CONTEXTHOLDER = new ThreadLocal<>();
  
  private DynamicFormContextHolder() {
    
  }
  
  public static void clearContext() {
    CONTEXTHOLDER.remove();
  }

  public static DynamicFormContext getContext() {
    DynamicFormContext ctx = CONTEXTHOLDER.get();
    if (ctx == null) {
        ctx = createEmptyContext();
        CONTEXTHOLDER.set(ctx);
    }
    return ctx;
  }

  private static DynamicFormContext createEmptyContext() {
    return new DynamicFormContextImpl();
  }
}
