package com.biz.crm.common.form.sdk.field.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.biz.crm.common.form.sdk.field.ValidateStrategy;

/**
 * 该注释用于描述@DynamicField注解中的某一个验证策略信息
 * @author yinwenjie
 */
@Documented
@Target(ElementType.ANNOTATION_TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Validate {
  
  /**
   * 指定的验证策略
   * @return
   */
  Class<? extends ValidateStrategy> value();
  
  /**
   * 如果验证策略需要有传入值，则可以在这里传入。</br>
   * 例如RegExValidateStrategy验证策略，需要传入一个正则表达式信息
   * @return
   */
  String[] inputs() default {};
}
