package com.biz.crm.common.form.sdk.field.validate;

import java.lang.reflect.Field;

import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.field.ValidateStrategy;

/**
 * 该验证策略用于检查字段值是否为null，如果为null，则抛出异常
 * @author yinwenjie
 */
@Component
public class NotNullValidateStrategy implements ValidateStrategy {

  @Override
  public void validate(Object fieldValue, String fieldName, Field field, Object dynamicForm) {
    Validate.notNull(fieldValue, "%s信息不能为空，请检查!!" , fieldName);
  }
}
