package com.biz.crm.common.form.sdk.context;

import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Maps;

/**
 * DynamicFormContext数据权限上下文的默认实现
 * @author yinwenjie
 */
class DynamicFormContextImpl implements DynamicFormContext {

  /**
   * 目前上下文里面只有一个Map性质的集合，操作者可供使用
   */
  private Map<String , Object> maps = Maps.newLinkedHashMap();

  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormContextImpl.class);
  
  public void put(String key , Object val) {
    if(StringUtils.isBlank(key) || val == null) {
      LOGGER.error("动态表单上下文操作时，不允许key或者value为空");
      return;
    }
    
    maps.put(key, val);
  }
  
  public Object get(String key) {
    return this.maps.get(key);
  }
  
  public Set<String> keys() {
    return this.maps.keySet();
  }
  
  public boolean exist(String key) {
    return this.maps.get(key) != null;
  }
}
