package com.biz.crm.common.form.sdk.dto;

import java.util.List;
import lombok.Getter;
import lombok.Setter;

/**
 * @author ning.zhang
 * @description 动态表单字段绑定dto
 * @date 2024/08/16
 */
@Getter
@Setter
public class DynamicFormFieldMappingRebindDto {

  /**
   * 用于处理该动态表单结构的操作处理策略业务编码（全系统唯一）
   */
  private String dynamicFormCode;
  /**
   * 该动态表单结构的操作处理策略业务编码（全系统唯一）
   */
  private String mappingCode;
  /**
   * 字段编码集合（按顺序传递）
   */
  private List<String> fieldCodes;
  /**
   * 字段名称集合（按顺序传递）
   */
  private List<String> fieldNames;
  /**
   * 字段是否为空集合（按顺序传递）
   */
  private List<Boolean> nullables;
  /**
   * 字段排序集合（按顺序传递）
   */
  private List<Integer> sortIndexs;
  /**
   * 字段分组集合（按顺序传递）
   */
  private List<String> groupIndexs;
}
