package com.biz.crm.common.form.sdk.field;

import java.lang.reflect.Field;

/**
 * 动态表单中提供给字段使用的验证策略
 * @author yinwenjie
 */
public interface ValidateStrategy {
  /**
   * 该方法进行动态表单上特定字段的验证
   * @param fieldValue 字段值（注意字段值的类型）
   * @param fieldName 字段名称（由相关注解中的fieldName属性提供）
   * @param field 字段完整信息
   * @param dynamicForm 字段对应的动态表单
   * @throws 如果验证出现问题，则请抛出异常（推荐抛出类似于IllegalArgumentException这样的参数异常），如果验证通过，则无需抛出任何异常
   */
  public void validate(Object fieldValue , String fieldName , Field field , Object dynamicForm);
}
