package com.biz.crm.common.form.sdk.field.validate;

import java.lang.reflect.Field;
import java.util.regex.Pattern;

import org.apache.commons.lang3.Validate;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.field.ValidateStrategy;

/**
 * 该验证器主要使用一个正则表达式，针对一个字符串性质的字段值进行验证。如果验证不通过，则抛出异常。如果字段不是字符串性质的字段，则忽略验证过程
 * @author yinwenjie
 */
@Component
@Scope("prototype")
public class RegExValidateStrategy implements ValidateStrategy {

  private String regex;
  
  public RegExValidateStrategy(String regex) {
    this.regex = regex;
  }
  
  @Override
  public void validate(Object fieldValue, String fieldName, Field field, Object dynamicForm) {
    String regexTarget = null;
    if(fieldValue == null) {
      return;
    }
    regexTarget = fieldValue.toString();
    
    Pattern pattern = Pattern.compile(this.regex);
    Validate.isTrue(pattern.matcher(regexTarget).matches(), "%s信息不符合格式要求，请按照页面要求填写信息!!" , fieldName);
  }

}
