package com.biz.crm.common.form.sdk.vo;

import java.lang.reflect.Field;

import com.alibaba.fastjson.annotation.JSONField;
import com.biz.crm.common.form.sdk.codec.WidgetKeyCodec;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.widget.WidgetKey;

import lombok.Getter;
import lombok.Setter;

/**
 * 该vo用于描述一个动态表单中被设定的字段信息
 * @author yinwenjie
 */
@Getter
@Setter
public class DynamicFieldVo {
  /**
   * 该字段的详细信息
   */
  @JSONField(serialize = false)
  private Field field;
  /**
   * 字段的类型
   */
  private Class<?> fieldClass;
  /**
   * 该字段是否是数组
   */
  private Boolean array;
  /**
   * 该字段是否是集合：注意，不会出现数组和集合同时为true的情况；否则会在解析时抛出异常
   */
  private Boolean collection;
  /**
   * 字段的中文说明——来自于注解
   */
  private String fieldName;
  /**
   * 字段的英文名
   */
  private String fieldCode;
  /**
   * 字段在前端页面上，是否必填
   */
  private boolean required;
  /**
   * 字段信息在前端页面是否允许修改
   */
  private boolean modifiable;
  /**
   * 字段排序信息
   */
  private Integer sortIndex;
  /**
   * 字段分组信息
   */
  private String groupIndex;
  /**
   * 字段在页面上使用的控件信息——来自于注解
   */
  @JSONField(serialize = true , serializeUsing = WidgetKeyCodec.class)
  private WidgetKey controllKey;
  /**
   * 字段的验证策略——来自于注解
   */
  @JSONField(serialize = false)
  private Validate[] validates;
}
