package com.biz.crm.common.form.sdk.vo;

import java.util.List;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class DynamicChildrenFormVo implements IDynamicForm {
  /**
   * 该动态表单结构来自于父级主表结构的哪一个字段（字段名）</br>
   * 注意，该字段一定是一个Collection集合结构
   */
  private String parentFieldCode;
  /**
   * 该动态表单结构中的动态字段信息（注意，只有使用了DynamicField注解的，由开发人员定义的字段，才是动态字段）
   */
  private List<DynamicFieldVo> dynamicFields;
  /**
   * 该子级结构中的下级子级明细结构</br>
   * 注意，结构关联的字段，一定是collection集合
   */
  private List<DynamicChildrenFormVo> childrenForms;
}
