package com.biz.crm.common.form.sdk.widget;

import java.util.Map;

/**
 * 控件描述信息</br>
 * TODO CRM的后续版本中，针对前端控件的管理，将采用XML或者JSON信息，采用上传/下载的方式进行维护</p>
 * 
 * 另外，请注意，该接口要被系统识别到，请将接口的具体实现类加入到IOC容器中
 * 
 * @author yinwenjie
 */
public interface WidgetKey {
  /**
   * 控件在整个系统中唯一的业务编号
   * @return
   */
  public String widgetCode();
  
  /**
   * 控件的名字（作用）
   * @return
   */
  public String widgetName();
  
  /**
   * 控件的扩展信息（例如如果是针对数据字典的下拉控件，那这里可以记录数据字典的固定编号）</br>
   * 注意，这部分信息只能固定，也就是说如果针对两个不同数据字典的，那么就需要两个控件
   * @return
   */
  public Map<String , Object> widgetParam();
}
