package com.biz.crm.common.form.sdk.widget;

import java.util.Map;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.sdk.widget.WidgetKey;

/**
 * 是/否的下拉选择控件
 * @author yinwenjie
 */
@Component
public class BooleanSelectWidget implements WidgetKey {

  @Override
  public String widgetCode() {
    return "booleanSelectWidget";
  }

  @Override
  public String widgetName() {
    return "是/否的下拉选择控件";
  }

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, Object> widgetParam() {
    JSONObject booleanObject = new JSONObject();
    booleanObject.put("是", 1);
    booleanObject.put("否", 0);
    
    JSONObject jsonObject = new JSONObject();
    jsonObject.put("valueMapping", booleanObject);
    
    Map<String , Object> valueMapping = (Map<String , Object>)JSON.parse(jsonObject.toJSONString());
    return valueMapping;
  }
}
