package com.biz.crm.common.form.sdk;

/**
 * 在动态表单结构服务进行具体构建时，该接口的实现负责进行某个具体的主业务表上字段（Map性质的字段）的构建
 * @author yinwenjie
 * @param <T>
 */
public interface DynamicFieldConfiguration<T> {
  
  /**
   * 为主模型上特定的字段，设定其值和动态表单处理策略业务编号（即dynamicFormCode的对应关系）
   * @param dynamicKey 特定的Map字段中，其Key部分的值
   * @param dynamicFormCode 该Key部分的值，对应的动态表单处理策略业务编号（即dynamicFormCode的对应关系）
   * @return 按照构建模式的要求，返回DynamicFieldConfiguration对象自己
   */
  public DynamicFieldConfiguration<T> addDynamicMapping(String dynamicKey , String dynamicFormCode);
  
  /**
   * 设定完成，重新回到上层的基于主模型的动态表单结构的设定
   * @return
   */
  public DynamicFormServiceBuilder<T> config();
  
  // 
  public String getField();
  
  public boolean isValueCollection();

  public Class<?> getCollectionClass();
  
  /**
   * 查询当前特定的动态表单模型字段/属性上，已设定的值信息。即这个Map性质的字段已经设定的Key信息
   * @return 
   */
  public String[] findDynamicKeys();
  
  public String findDynamicFormCodeByDynamicKey(String dynamicKey);
}
