package com.biz.crm.common.form.sdk.model;

import org.springframework.core.Ordered;

/**
 * 请不要直接集成或者实现OperationStrategy接口，
 * 应该根据自身的业务情况实现DynamicFormOperationStrategy接口或者DynamicFormsOperationStrategy接口
 * @author yinwenjie 
 * @param <T> 实现了DynamicForm接口的各种模型，都可以被关联到动态表单策略器中
 */
public interface OperationStrategy<T extends DynamicForm> extends Ordered {
  /**
   * 必须设定动态表单的业务编码（全系统唯一）。</br>
   * 那么可以采用“子系统_功能名”的方式，来对动态表单进行标识
   */
  public String dynamicFormCode();
  
  /**
   * 必须设定动态表单的中文名，以便页面上进行展示
   */
  public String dynamicFormName();
  
  /**
   * 必须设定动态表单的模型结构类，模型一般来说是一个VO或者DTO，且该模型一定实现了DynamicForm接口</br>
   * 注意：动态表单的模型和操作策略，是一对一的，全系统中只有唯一的OperationStrategy处理策略对应唯一的动态表单结构模型
   */
  public Class<T> dynamicFormClass();
  
  /**
   * 该动态表单操作策略所属的“模块”信息，模块信息的moduleCode必须和某一个ModuleRegister的实现中给定的moduleCode一致
   */
  public String moduleCode();
  
  /**
   * 该方法定义用于删除特定dynamicKey（主业务模型中某个Map性质的抽象字段/属性下的一个Key维度）对应的动态表单数据
   * @param parentCode 主业务模型和当前动态表单数据的关联业务编号
   * @param dynamicKey 主业务模型中某个Map性质的抽象字段/属性下的一个Key维度
   */
  public void onDynamicFormsDelete(String parentCode , String dynamicKey);
}
