package com.biz.crm.common.form.sdk.context;

import java.util.Set;

/**
 * CRM 3.0 动态表单上下文</p>
 * @author yinwenjie
 */
public interface DynamicFormContext {
  /**
   * 向动态表单上下文中设定一组K-V接口，请注意，Key和value都不允许为空，否则设置失败
   */
  public void put(String key , Object val);
  
  /**
   * 从动态表单上下文获取指定key的value信息；注意，如果没有这个key，则返回为null
   */
  public Object get(String key);
  
  /**
   * 从动态表单上下文获取目前存在的所有key信息
   * @return
   */
  public Set<String> keys();
  
  public boolean exist(String key);
}
